/**
 * WekaMenuItemCodelet.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.menu;

import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.AbstractMenuItemDefinition;
import adams.gui.goe.AbstractEditorRegistration;

/**
 * Abstract menu item menu item definitions for Weka elements.
 * Defines the WEKA icon already.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3042 $
 */
public abstract class AbstractWekaMenuItemDefinition
  extends AbstractMenuItemDefinition {

  /** for serialization. */
  private static final long serialVersionUID = 1668108539323372465L;

  /**
   * Initializes the menu item.
   *
   * @param owner	the owning application
   */
  protected AbstractWekaMenuItemDefinition(AbstractApplicationFrame owner) {
    super(owner);
  }

  /**
   * Returns the file name of the icon.
   *
   * @return		the filename or null if no icon available
   */
  public String getIconName() {
    return "weka_icon.gif";
  }

  /**
   * Returns the category of the menu item in which it should appear, i.e.,
   * the name of the menu.
   *
   * @return		the category/menu name
   */
  public String getCategory() {
    return "WEKA";
  }

  /**
   * Hook method that gets executed just before calling "launch()".
   * <p/>
   * Registers the GOE editors.
   */
  public void preLaunch() {
    super.preLaunch();
    AbstractEditorRegistration.registerEditors();
  }
}
