/*
 * ContainerValuePickerTest.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.control;

import java.io.File;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.container.WekaModelContainer;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.SingleFileSupplier;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaClassifier;
import adams.flow.transformer.WekaFileReader;
import adams.test.TmpFile;

/**
 * Tests the ContainerValuePicker actor.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3209 $
 */
public class ContainerValuePickerTest
  extends AbstractFlowTest {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public ContainerValuePickerTest(String name) {
    super(name);
  }

  /**
   * Called by JUnit before each test method. Copies from resource files into
   * the tmp directory
   *
   * @throws Exception if an error occurs reading the example instances.
   */
  protected void setUp() throws Exception {
    super.setUp();

    m_TestHelper.copyResourceToTmp("vote.arff");
  }

  /**
   * Called by JUnit after each test method. Removes some tmp files again.
   *
   * @throws Exception	if tear-down fails
   */
  protected void tearDown() throws Exception {
    m_TestHelper.deleteFileFromTmp("vote.arff");
    m_TestHelper.deleteFileFromTmp("dumpfile_all.txt");
    m_TestHelper.deleteFileFromTmp("dumpfile_model.txt");

    super.tearDown();
  }

  /**
   * Used to create an instance of a specific actor.
   *
   * @return a suitably configured <code>AbstractActor</code> value
   */
  public AbstractActor getActor() {
    SingleFileSupplier sfs = new SingleFileSupplier();
    sfs.setFile(new TmpFile("vote.arff"));

    WekaFileReader fr = new WekaFileReader();

    WekaClassSelector cs = new WekaClassSelector();

    WekaClassifier cls = new WekaClassifier();
    cls.setClassifier(new weka.classifiers.trees.J48());

    DumpFile df_model = new DumpFile();
    df_model.setOutputFile(new TmpFile("dumpfile_model.txt"));

    ContainerValuePicker cvp = new ContainerValuePicker();
    cvp.setValueName(WekaModelContainer.VALUE_MODEL);
    cvp.add(0, df_model);

    DumpFile df_all = new DumpFile();
    df_all.setOutputFile(new TmpFile("dumpfile_all.txt"));

    Flow flow = new Flow();
    flow.setActors(new AbstractActor[]{sfs, fr, cs, cls, cvp, df_all});

    return flow;
  }

  /**
   * Performs a regression test, comparing against previously generated output.
   */
  public void testRegression() {
    performRegressionTest(
	new File[]{
	    new TmpFile("dumpfile_all.txt"),
	    new TmpFile("dumpfile_model.txt")});
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(ContainerValuePickerTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
