/*
 * WekaRegexToRangeTest.java
 * Copyright (C) 2010-2011 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.transformer;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Branch;
import adams.flow.control.Flow;
import adams.flow.control.Sequence;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorReference;
import adams.flow.standalone.GlobalActors;
import adams.flow.sink.DumpFile;
import adams.flow.sink.GlobalSink;
import adams.flow.source.SingleFileSupplier;
import adams.test.TmpFile;

/**
 * Tests the WekaRegexToRange actor.
 *
 * @author  dale (dale at waikato dot ac dot nz)
 * @version $Revision: 2934 $
 */
public class WekaRegexToRangeTest
  extends AbstractFlowTest {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public WekaRegexToRangeTest(String name) {
    super(name);
  }

  /**
   * Called by JUnit before each test method.
   *
   * @throws Exception if an error occurs reading the example instances.
   */
  protected void setUp() throws Exception {
    super.setUp();

    m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    m_TestHelper.copyResourceToTmp("labor.arff");
  }

  /**
   * Called by JUnit after each test method.
   *
   * @throws Exception	if tear-down fails
   */
  protected void tearDown() throws Exception {
    m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    m_TestHelper.deleteFileFromTmp("labor.arff");

    super.tearDown();
  }

  /**
   * Used to create an instance of a specific actor.
   *
   * @return a suitably configured <code>Flow</code>
   */
  public AbstractActor getActor() {
    DumpFile df = new DumpFile();
    df.setName("out");
    df.setAppend(true);
    df.setOutputFile(new TmpFile("dumpfile.txt"));

    GlobalActors ga = new GlobalActors();
    ga.setActors(new AbstractActor[]{
	df
    });

    SingleFileSupplier sfs = new SingleFileSupplier();
    sfs.setFile(new TmpFile("labor.arff"));

    WekaFileReader fr = new WekaFileReader();

    WekaRegexToRange rtr1 = new WekaRegexToRange();

    GlobalSink gs1 = new GlobalSink();
    gs1.setGlobalName(new GlobalActorReference("out"));

    Sequence s1 = new Sequence();
    s1.setActors(new AbstractActor[]{
	rtr1,gs1
    });

    WekaRegexToRange rtr2 = new WekaRegexToRange();
    rtr2.setRegex("wage-.*");

    GlobalSink gs2 = new GlobalSink();
    gs2.setGlobalName(new GlobalActorReference("out"));

    Sequence s2 = new Sequence();
    s2.setActors(new AbstractActor[]{
	rtr2,gs2
    });

    Branch br = new Branch();
    br.setNumThreads(0);
    br.setBranches(new AbstractActor[]{
	s1, s2
    });

    Flow flow = new Flow();
    flow.setActors(new AbstractActor[]{ga, sfs, fr, br});

    return flow;
  }

  /**
   * Performs a regression test, comparing against previously generated output.
   */
  public void testRegression() {
    performRegressionTest(
	new TmpFile("dumpfile.txt"));
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(WekaRegexToRangeTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
