/**
 * MatchWekaInstanceAgainstFileHeader.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.data.conversion;

import weka.core.Instances;
import weka.core.converters.ConverterUtils.DataSource;
import adams.core.io.PlaceholderFile;

/**
 <!-- globalinfo-start -->
 * Matches an Instance against a dataset header loaded from a file, i.e., it automatically converts STRING attributes into NOMINAL ones and vice versa.<br/>
 * The file can be any format that WEKA recognizes.
 * <p/>
 <!-- globalinfo-end -->
 *
 <!-- options-start -->
 * Valid options are: <p/>
 *
 * <pre>-D &lt;int&gt; (property: debugLevel)
 * &nbsp;&nbsp;&nbsp;The greater the number the more additional info the scheme may output to
 * &nbsp;&nbsp;&nbsp;the console (0 = off).
 * &nbsp;&nbsp;&nbsp;default: 0
 * &nbsp;&nbsp;&nbsp;minimum: 0
 * </pre>
 *
 * <pre>-header &lt;adams.core.io.PlaceholderFile&gt; (property: header)
 * &nbsp;&nbsp;&nbsp;The file to load the header from.
 * &nbsp;&nbsp;&nbsp;default: ${CWD}
 * </pre>
 *
 <!-- options-end -->
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4011 $
 */
public class MatchWekaInstanceAgainstFileHeader
  extends AbstractMatchWekaInstanceAgainstHeader {

  /** for serialization. */
  private static final long serialVersionUID = -5909149413572601612L;

  /** the header to load from disk. */
  protected PlaceholderFile m_Header;

  /**
   * Returns a string describing the object.
   *
   * @return 			a description suitable for displaying in the gui
   */
  public String globalInfo() {
    return
        "Matches an Instance against a dataset header loaded from a file, i.e., "
      + "it automatically converts STRING attributes into NOMINAL ones and "
      + "vice versa.\n"
      + "The file can be any format that WEKA recognizes.";
  }

  /**
   * Adds options to the internal list of options.
   */
  public void defineOptions() {
    super.defineOptions();

    m_OptionManager.add(
	    "header", "header",
	    new PlaceholderFile("."));
  }

  /**
   * Sets the file to load the dataset header from.
   *
   * @param value	the file
   */
  public void setHeader(PlaceholderFile value) {
    m_Header = value;
    reset();
  }

  /**
   * Returns the file to load the dataset header from.
   *
   * @return		the file
   */
  public PlaceholderFile getHeader() {
    return m_Header;
  }

  /**
   * Returns the tip text for this property.
   *
   * @return		tip text for this property suitable for
   * 			displaying in the GUI or for listing the options.
   */
  public String headerTipText() {
    return "The file to load the header from.";
  }

  /**
   * Acquires the header.
   *
   * @return		the header to match against
   */
  protected Instances getDatasetHeader() {
    Instances	result;

    try {
      result = DataSource.read(m_Header.getAbsolutePath());
    }
    catch (Exception e) {
      getSystemErr().println("Failed to load header from: " + m_Header);
      getSystemErr().printStackTrace(e);
      throw new IllegalStateException(e);
    }

    return result;
  }
}
