/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.core.Range;
import weka.core.converters.ArffLoader;
import weka.filters.AbstractAdamsFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.CorrelationMatrix;
import weka.test.AdamsTestHelper;

public class CorrelationMatrixTest
extends AbstractAdamsFilterTest {
    public CorrelationMatrixTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        ArffLoader loader = new ArffLoader();
        loader.setSource(ClassLoader.getSystemResource("weka/filters/data/bolts.arff"));
        this.m_Instances = loader.getDataSet();
        this.m_Instances.setClassIndex(this.m_Instances.numAttributes() - 1);
    }

    protected Instances getFilteredClassifierData() {
        return null;
    }

    public void testFilteredClassifier() {
    }

    public Filter getFilter() {
        return new CorrelationMatrix();
    }

    public Filter getFilter(String range, boolean abs) {
        CorrelationMatrix result = new CorrelationMatrix();
        result.setAttributeRange(range);
        result.setAbsolute(abs);
        return result;
    }

    protected void performTest() {
        int i;
        Instances icopy = new Instances(this.m_Instances);
        Instances result = null;
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            CorrelationMatrixTest.fail((String)("Exception thrown on setInputFormat(): \n" + ex.getMessage()));
        }
        try {
            result = Filter.useFilter((Instances)icopy, (Filter)this.m_Filter);
            CorrelationMatrixTest.assertNotNull((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            CorrelationMatrixTest.fail((String)("Exception thrown on useFilter(): \n" + ex.getMessage()));
        }
        CorrelationMatrix filter = (CorrelationMatrix)this.m_Filter;
        Range range = new Range(filter.getAttributeRange());
        range.setUpper(icopy.numAttributes() - 1);
        int numeric = 0;
        for (i = 0; i < icopy.numAttributes(); ++i) {
            if (!range.isInRange(i) || !icopy.attribute(i).isNumeric()) continue;
            ++numeric;
        }
        CorrelationMatrixTest.assertEquals((String)"Number of attributes", (int)(numeric + 1), (int)result.numAttributes());
        CorrelationMatrixTest.assertEquals((String)"Number of instances", (int)numeric, (int)result.numInstances());
        for (i = 1; i < result.numAttributes(); ++i) {
            for (int n = 0; n < result.numInstances(); ++n) {
                double val = result.instance(n).value(i);
                if (filter.getAbsolute()) {
                    CorrelationMatrixTest.assertTrue((String)"0.0 <= coeff <= +1.0", (val >= 0.0 && val <= 1.0 ? 1 : 0) != 0);
                    continue;
                }
                CorrelationMatrixTest.assertTrue((String)"-1.0 <= coeff <= +1.0", (val >= -1.0 && val <= 1.0 ? 1 : 0) != 0);
            }
        }
    }

    public void testDefault() {
        this.m_Filter = this.getFilter();
        this.testBuffered();
        this.performTest();
    }

    public void testAbsolute() {
        this.m_Filter = this.getFilter("first-last", true);
        this.testBuffered();
        this.performTest();
    }

    public void testRange() {
        this.m_Filter = this.getFilter("3-last", false);
        this.testBuffered();
        this.performTest();
    }

    public static Test suite() {
        return new TestSuite(CorrelationMatrixTest.class);
    }

    public static void main(String[] args) {
        AdamsTestHelper.setRegressionRoot();
        TestRunner.run((Test)CorrelationMatrixTest.suite());
    }
}

