/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.core.TestInstances;
import weka.filters.AbstractAdamsFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.SavitzkyGolay;
import weka.test.AdamsTestHelper;

public class SavitzkyGolayTest
extends AbstractAdamsFilterTest {
    public SavitzkyGolayTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_Instances = this.getFilteredClassifierData();
    }

    protected Instances getFilteredClassifierData() throws Exception {
        TestInstances testinst = new TestInstances();
        testinst.setNumNominal(0);
        testinst.setNumNumeric(20);
        testinst.setClassType(1);
        testinst.setNumInstances(50);
        return testinst.generate();
    }

    public Filter getFilter() {
        return new SavitzkyGolay();
    }

    public Filter getFilter(int left, int right, int poly, int der) {
        SavitzkyGolay result = new SavitzkyGolay();
        result.setNumPointsLeft(left);
        result.setNumPointsRight(right);
        result.setPolynomialOrder(poly);
        result.setDerivativeOrder(der);
        return result;
    }

    protected void performTest() {
        Instances icopy = new Instances(this.m_Instances);
        Instances result = null;
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            SavitzkyGolayTest.fail((String)("Exception thrown on setInputFormat(): \n" + ex.getMessage()));
        }
        try {
            result = Filter.useFilter((Instances)icopy, (Filter)this.m_Filter);
            SavitzkyGolayTest.assertNotNull((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            SavitzkyGolayTest.fail((String)("Exception thrown on useFilter(): \n" + ex.getMessage()));
        }
        SavitzkyGolay filter = (SavitzkyGolay)this.m_Filter;
        int numAtts = icopy.numAttributes();
        SavitzkyGolayTest.assertEquals((int)(numAtts -= filter.getNumPointsLeft() + filter.getNumPointsRight() + 1), (int)result.numAttributes());
        SavitzkyGolayTest.assertEquals((int)icopy.numInstances(), (int)this.m_Instances.numInstances());
    }

    public void testDefault() {
        this.m_Filter = this.getFilter();
        this.testBuffered();
        this.performTest();
    }

    public void testNoLeft() {
        this.m_Filter = this.getFilter(0, 3, 2, 1);
        this.testBuffered();
        this.performTest();
    }

    public void testNoRight() {
        this.m_Filter = this.getFilter(3, 0, 2, 1);
        this.testBuffered();
        this.performTest();
    }

    public void testNoDerivative() {
        this.m_Filter = this.getFilter(3, 3, 2, 0);
        this.testBuffered();
        this.performTest();
    }

    public static Test suite() {
        return new TestSuite(SavitzkyGolayTest.class);
    }

    public static void main(String[] args) {
        AdamsTestHelper.setRegressionRoot();
        TestRunner.run((Test)SavitzkyGolayTest.suite());
    }
}

