/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import adams.data.statistics.StatUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.UnsupervisedFilter;

public class CorrelationMatrix
extends SimpleBatchFilter
implements UnsupervisedFilter {
    private static final long serialVersionUID = 2353556679864963099L;
    protected Range m_AttributeRange = new Range("first-last");
    protected boolean m_Absolute;
    protected Vector<Integer> m_Indices;

    public String globalInfo() {
        return "Computes a matrix with the correlation coefficients between attributes.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement(enm.nextElement());
        }
        result.addElement(new Option("\tThe range of attributes to compute the matrix for.\n\t(default: first-last)", "R", 1, "-R <range specification>"));
        result.addElement(new Option("\tIf turned on, the absolute values of the correlation coefficients\n\tare returned.\n\t(default: off)", "absolute", 0, "-absolute"));
        return result.elements();
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>(Arrays.asList(super.getOptions()));
        result.add("-R");
        result.add("" + this.getAttributeRange());
        if (this.getAbsolute()) {
            result.add("-absolute");
        }
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption((String)"R", (String[])options);
        if (tmpStr.length() != 0) {
            this.setAttributeRange(tmpStr);
        } else {
            this.setAttributeRange("first-last");
        }
        this.setAbsolute(Utils.getFlag((String)"absolute", (String[])options));
    }

    public String attributeRangeTipText() {
        return "The range of attributes to compute the matrix for.";
    }

    public void setAttributeRange(String value) {
        this.m_AttributeRange.setRanges(value);
    }

    public String getAttributeRange() {
        return this.m_AttributeRange.getRanges();
    }

    public String absoluteTipText() {
        return "If set to true, the absolute values of the correlation coefficients are returned.";
    }

    public void setAbsolute(boolean value) {
        this.m_Absolute = value;
    }

    public boolean getAbsolute() {
        return this.m_Absolute;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        int i;
        this.m_AttributeRange.setUpper(inputFormat.numAttributes() - 1);
        this.m_Indices = new Vector();
        ArrayList<String> attVals = new ArrayList<String>();
        for (i = 0; i < inputFormat.numAttributes(); ++i) {
            if (!this.m_AttributeRange.isInRange(i) || !inputFormat.attribute(i).isNumeric()) continue;
            this.m_Indices.add(i);
            attVals.add(inputFormat.attribute(i).name());
        }
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        atts.add(0, new Attribute("x", attVals));
        for (i = 0; i < attVals.size(); ++i) {
            atts.add(new Attribute((String)attVals.get(i)));
        }
        Instances result = new Instances("CorrelationMatrix: " + inputFormat.relationName(), atts, 0);
        return result;
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    protected Instances process(Instances instances) throws Exception {
        double[] first;
        int i;
        Instances result = this.getOutputFormat();
        for (i = 0; i < this.m_Indices.size(); ++i) {
            first = new double[result.numAttributes()];
            first[0] = i;
            first[i + 1] = 1.0;
            result.add((Instance)new DenseInstance(1.0, first));
        }
        for (i = 0; i < this.m_Indices.size() - 1; ++i) {
            first = instances.attributeToDoubleArray(this.m_Indices.get(i).intValue());
            for (int n = i + 1; n < this.m_Indices.size(); ++n) {
                double[] second = instances.attributeToDoubleArray(this.m_Indices.get(n).intValue());
                double correlation = StatUtils.correlationCoefficient((double[])first, (double[])second);
                if (this.m_Absolute) {
                    correlation = Math.abs(correlation);
                }
                result.instance(i).setValue(n + 1, correlation);
                result.instance(n).setValue(i + 1, correlation);
            }
        }
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 3621 $");
    }

    public static void main(String[] args) {
        CorrelationMatrix.runFilter((Filter)new CorrelationMatrix(), (String[])args);
    }
}

