/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SimpleStreamFilter;
import weka.filters.UnsupervisedFilter;

public class DownSample
extends SimpleStreamFilter
implements UnsupervisedFilter {
    private static final long serialVersionUID = 5944266872914953692L;
    protected int m_NthPoint = 1;

    public String globalInfo() {
        return "A simple filter that retains only every nth attribute.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.add(enm.nextElement());
        }
        result.addElement(new Option("\tOnly every n-th point will be output (>0).\n\t(default: 1)", "nth", 1, "-nth <int>"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.reset();
        String tmpStr = Utils.getOption((String)"nth", (String[])options);
        if (tmpStr.length() > 0) {
            this.setNthPoint(Integer.parseInt(tmpStr));
        } else {
            this.setNthPoint(1);
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>(Arrays.asList(super.getOptions()));
        result.add("-nth");
        result.add("" + this.getNthPoint());
        return result.toArray(new String[result.size()]);
    }

    public void setNthPoint(int value) {
        if (value > 0) {
            this.m_NthPoint = value;
            this.reset();
        } else {
            System.err.println("'n' must be larger than 0 (provided: " + value + ")!");
        }
    }

    public int getNthPoint() {
        return this.m_NthPoint;
    }

    public String nthPointTipText() {
        return "Only every n-th point will be output (>0).";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        boolean hasClass = inputFormat.classIndex() > -1;
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        int count = 0;
        for (int i = 0; i < inputFormat.numAttributes(); ++i) {
            if (i == inputFormat.classIndex() || ++count % this.m_NthPoint != 0) continue;
            atts.add((Attribute)inputFormat.attribute(i).copy());
        }
        if (hasClass) {
            atts.add((Attribute)inputFormat.classAttribute().copy());
        }
        Instances result = new Instances(inputFormat.relationName(), atts, 0);
        if (hasClass) {
            result.setClassIndex(result.numAttributes() - 1);
        }
        return result;
    }

    protected Instance process(Instance instance) throws Exception {
        boolean hasClass = instance.classIndex() > -1;
        double[] valuesOld = instance.toDoubleArray();
        double[] values = new double[this.getOutputFormat().numAttributes()];
        int count = 0;
        int n = 0;
        for (int i = 0; i < valuesOld.length; ++i) {
            if (i == instance.classIndex() || ++count % this.m_NthPoint != 0) continue;
            values[n] = valuesOld[i];
            ++n;
        }
        if (hasClass) {
            values[values.length - 1] = instance.classValue();
        }
        DenseInstance result = new DenseInstance(instance.weight(), values);
        result.setDataset(this.getOutputFormat());
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 3621 $");
    }

    public static void main(String[] args) {
        DownSample.runFilter((Filter)new DownSample(), (String[])args);
    }
}

