/*
 * FitnessChangeEvent.java
 * Copyright (C) 2008 University of Waikato, Hamilton, New Zealand
 */

package adams.event;

import java.util.EventObject;

import adams.genetic.MTAbstractGeneticAlgorithm;
import adams.optimise.genetic.AbstractGeneticAlgorithm;

/**
 * Event that gets sent whenever the fitness of a genetic algorithm 
 * changed.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2822 $
 */
public class FitnessChangeEvent
  extends EventObject {

  /** for serialization. */
  private static final long serialVersionUID = 4900409199763866247L;

  /** the fitness that triggered this event. */
  protected double m_Fitness;
  
  /**
   * Initializes the event.
   * 
   * @param source	the algorithm that triggered the event
   * @param fitness	the fitness that triggered this event
   */
  public FitnessChangeEvent(MTAbstractGeneticAlgorithm source, double fitness) {
    super(source);
    
    m_Fitness = fitness;
  }
  
  /**
   * Returns the genetic algorithm that triggered the event.
   * 
   * @return		the genetic algorithm
   */
  public AbstractGeneticAlgorithm getGeneticAlgorithm() {
    return (AbstractGeneticAlgorithm) getSource();
  }
  
  /**
   * Returns the fitness that triggered this event.
   * 
   * @return		the fitness
   */
  public double getFitness() {
    return m_Fitness;
  }
}
