/*
 * FitnessChangeListener.java
 * Copyright (C) 2008 University of Waikato, Hamilton, New Zealand
 */

package adams.event;


/**
 * Interface for classes that listen to changes in the fitness of a genetic
 * algorithm.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2822 $
 */
public interface FitnessChangeListener {

  /**
   * Gets called when the fitness of the genetic algorithm changed.
   * 
   * @param e		the event
   */
  public void fitnessChanged(FitnessChangeEvent e);
}
