/*
 * FitnessChangeNotifier.java
 * Copyright (C) 2008 University of Waikato, Hamilton, New Zealand
 */

package adams.event;


/**
 * Interface for genetic algorithms that notify other objects about
 * changes of their fitness.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2822 $
 */
public interface FitnessChangeNotifier {

  /**
   * Returns the best currently best fitness.
   * 
   * @return		the fitness
   */
  public double getCurrentFitness();
  
  /**
   * Adds the given listener to its internal list of listeners.
   * 
   * @param l		the listener to add
   */
  public void addFitnessChangeListener(FitnessChangeListener l);

  /**
   * Removes the given listener from its internal list of listeners.
   * 
   * @param l		the listener to remove
   */
  public void removeFitnessChangeListener(FitnessChangeListener l);
}
