/*
 * AbstractWekaInstanceAndWekaInstancesTransformer.java
 * Copyright (C) 2009-2010 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.transformer;

import adams.flow.transformer.AbstractTransformer;

/**
 * Transformer that processes weka.core.Instance, weka.core.Instances
 * or adams.data.instance.Instance objects.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2823 $
 */
public abstract class AbstractWekaInstanceAndWekaInstancesTransformer
  extends AbstractTransformer {

  /** for serialization. */
  private static final long serialVersionUID = 1777730597434025843L;

  /**
   * Returns the class that the consumer accepts.
   *
   * @return		weka.core.Instance, weka.core.Instances, adams.data.instance.Instance
   */
  public Class[] accepts() {
    return new Class[]{weka.core.Instance.class, weka.core.Instances.class, adams.data.instance.Instance.class};
  }

  /**
   * Returns the class of objects that it generates.
   *
   * @return		weka.core.Instance, weka.core.Instances, adams.data.instance.Instance
   */
  public Class[] generates() {
    return new Class[]{weka.core.Instance.class, weka.core.Instances.class, adams.data.instance.Instance.class};
  }
}
