/**
 * AbstractParameterHandlingWekaMenuItemDefinition.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.menu;

import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.AdditionalParameterHandler;

/**
 * Abstract menu item definition for Weka elements that also handle additional
 * parameters.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2819 $
 */
public abstract class AbstractParameterHandlingWekaMenuItemDefinition
  extends AbstractWekaMenuItemDefinition
  implements AdditionalParameterHandler {

  /** for serialization. */
  private static final long serialVersionUID = 1668108539323372465L;

  /** the additional parameters. */
  protected String[] m_Parameters;

  /**
   * Initializes the menu item.
   *
   * @param owner	the owning application
   */
  protected AbstractParameterHandlingWekaMenuItemDefinition(AbstractApplicationFrame owner) {
    super(owner);
  }

  /**
   * Initializes the members.
   */
  protected void initialize() {
    super.initialize();

    m_Parameters = new String[0];
  }

  /**
   * Sets the additional parameters.
   *
   * @param params	the parameters
   */
  public void setAdditionalParameters(String[] params) {
    m_Parameters = params;
  }
}
