/*
 * ArffViewer.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 *
 */

package adams.gui.menu;

import javax.swing.JPanel;

import weka.gui.arffviewer.ArffViewerMainPanel;
import adams.core.io.PlaceholderFile;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.ChildFrame;
import adams.gui.application.UserMode;

/**
 * Opens the ARFF viewer.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2819 $
 */
public class ArffViewer
  extends AbstractParameterHandlingWekaMenuItemDefinition {

  /** for serialization. */
  private static final long serialVersionUID = 1279360379007337239L;

  /**
   * Initializes the menu item.
   *
   * @param owner	the owning application
   */
  public ArffViewer(AbstractApplicationFrame owner) {
    super(owner);
  }

  /**
   * Launches the functionality of the menu item.
   */
  public void launch() {
    JPanel dummy = new JPanel();
    ChildFrame frame = createChildFrame(dummy, 800, 600);
    ArffViewerMainPanel panel = new ArffViewerMainPanel(frame);
    frame.setJMenuBar(panel.getMenu());
    dummy.getParent().remove(dummy);
    frame.getContentPane().add(panel);
    // load files
    for (int i = 0; i < m_Parameters.length; i++)
      panel.loadFile(new PlaceholderFile(m_Parameters[i]).getAbsolutePath());
  }

  /**
   * Returns the title of the window (and text of menuitem).
   *
   * @return 		the title
   */
  public String getTitle() {
    return "Arff Viewer";
  }

  /**
   * Whether the panel can only be displayed once.
   *
   * @return		true if the panel can only be displayed once
   */
  public boolean isSingleton() {
    return false;
  }

  /**
   * Returns the user mode, which determines visibility as well.
   *
   * @return		the user mode
   */
  public UserMode getUserMode() {
    return UserMode.BASIC;
  }
}