/*
 * InstancesPlot.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 *
 */

package adams.gui.menu;

import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

import weka.core.Instances;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ConverterUtils;
import weka.gui.ConverterFileChooser;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.VisualizePanel;
import adams.core.io.PlaceholderFile;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.ChildFrame;
import adams.gui.application.UserMode;

/**
 * Displays plot of Instances.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2823 $
 */
public class InstancesPlot
  extends AbstractParameterHandlingWekaMenuItemDefinition {

  /** for serialization. */
  private static final long serialVersionUID = -771667287275117680L;

  /** filechooser for Plots. */
  protected ConverterFileChooser m_FileChooser;

  /**
   * Initializes the menu item.
   *
   * @param owner	the owning application
   */
  public InstancesPlot(AbstractApplicationFrame owner) {
    super(owner);
  }

  /**
   * Initializes members.
   */
  protected void initialize() {
    super.initialize();

    m_FileChooser = new ConverterFileChooser(new File(System.getProperty("user.dir")));
  }

  /**
   * Launches the functionality of the menu item.
   */
  public void launch() {
    File file;
    AbstractFileLoader loader;
    if (m_Parameters.length == 0) {
      // choose file
      int retVal = m_FileChooser.showOpenDialog(getOwner());
      if (retVal != JFileChooser.APPROVE_OPTION)
	return;
      file   = m_FileChooser.getSelectedFile();
      loader = m_FileChooser.getLoader();
    }
    else {
      file   = new PlaceholderFile(m_Parameters[0]).getAbsoluteFile();
      loader = ConverterUtils.getLoaderForFile(file);
    }

    // build plot
    VisualizePanel panel = new VisualizePanel();
    getSystemErr().println("Loading instances from " + file);
    try {
      loader.setFile(file);
      Instances i = loader.getDataSet();
      i.setClassIndex(i.numAttributes() - 1);
      PlotData2D pd1 = new PlotData2D(i);
      pd1.setPlotName("Master plot");
      panel.setMasterPlot(pd1);
    }
    catch (Exception e) {
      getSystemErr().printStackTrace(e);
      JOptionPane.showMessageDialog(
	  getOwner(), "Error loading file '" + file + "':\n" + e.getMessage());
      return;
    }

    // create frame
    ChildFrame frame = createChildFrame(panel, 800, 600);
    frame.setTitle(frame.getTitle()  + " - " + file);
  }

  /**
   * Returns the title of the window (and text of menuitem).
   *
   * @return 		the title
   */
  public String getTitle() {
    return "Instances plot";
  }

  /**
   * Whether the panel can only be displayed once.
   *
   * @return		true if the panel can only be displayed once
   */
  public boolean isSingleton() {
    return false;
  }

  /**
   * Returns the user mode, which determines visibility as well.
   *
   * @return		the user mode
   */
  public UserMode getUserMode() {
    return UserMode.BASIC;
  }
}