/**
 * WekaDatasetHandler.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.tools.previewbrowser;

import java.io.File;

import javax.swing.JPanel;

import adams.core.Utils;
import weka.gui.arffviewer.ArffPanel;

/**
 <!-- globalinfo-start -->
 * Displays the following WEKA dataset types: csv,arff,arff.gz,xrff,xrff.gz
 * <p/>
 <!-- globalinfo-end -->
 *
 <!-- options-start -->
 * Valid options are: <p/>
 *
 * <pre>-D &lt;int&gt; (property: debugLevel)
 * &nbsp;&nbsp;&nbsp;The greater the number the more additional info the scheme may output to
 * &nbsp;&nbsp;&nbsp;the console (0 = off).
 * &nbsp;&nbsp;&nbsp;default: 0
 * &nbsp;&nbsp;&nbsp;minimum: 0
 * </pre>
 *
 <!-- options-end -->
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2819 $
 */
public class WekaDatasetHandler
  extends AbstractContentHandler {

  /** for serialization. */
  private static final long serialVersionUID = -8339099303070121780L;

  /**
   * Returns a string describing the object.
   *
   * @return 			a description suitable for displaying in the gui
   */
  public String globalInfo() {
    return "Displays the following WEKA dataset types: " + Utils.arrayToString(getExtensions());
  }

  /**
   * Returns the list of extensions (without dot) that this handler can
   * take care of.
   *
   * @return		the list of extensions (no dot)
   */
  public String[] getExtensions() {
    return new String[]{"csv", "arff", "arff.gz", "xrff", "xrff.gz"};
  }

  /**
   * Creates the actual view.
   *
   * @param file	the file to create the view for
   * @return		the view
   */
  protected JPanel createPreview(File file) {
    return new ArffPanel(file.getAbsolutePath());
  }
}
