/*
 * InstanceContainerDisplayIDGenerator.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.instance;

import adams.gui.visualization.container.AbstractContainerDisplayStringGenerator;

/**
 * Class for generating display IDs for Instance objects (based on
 * weka.core.Instance objects).
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1272 $
 */
public class InstanceContainerDisplayIDGenerator
  extends AbstractContainerDisplayStringGenerator<InstanceContainer> {

  /** for serialization. */
  private static final long serialVersionUID = 5365866966393976397L;

  /**
   * Returns the display ID for the sequence.
   *
   * @param c		the sequence to get the display ID for
   * @return		the ID
   */
  public String getDisplay(InstanceContainer c) {
    return c.getData().getID().replaceAll("-weka\\.filters.*", "");
  }
}