/*
 * InstanceListPanel.java
 * Copyright (C) 2009-2010 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.instance;

import adams.gui.visualization.container.ContainerList;

/**
 * A panel that lists Instances in a JTable.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1606 $
 */
public class InstanceContainerList
  extends ContainerList<InstanceContainerManager,InstanceContainer> {

  /** for serialization. */
  private static final long serialVersionUID = 3265940348362833587L;

  /**
   * Creates a new model.
   *
   * @param manager	the manager to use for the model
   * @return		the new model
   */
  protected InstanceContainerModel createModel(InstanceContainerManager manager) {
    return new InstanceContainerModel(manager);
  }
}
