/*
 * PackDataGeneticAlgorithm.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.optimise.genetic;

import java.util.Vector;

/**
 * ???
 *
 * @author Dale (dale at cs dot waikato dot ac dot nz)
 * @version $Revision: 1185 $
 */
public abstract class PackDataGeneticAlgorithm
  extends AbstractGeneticAlgorithm {

  /** suid.*/
  private static final long serialVersionUID = 4301615908806659455L;

  protected PackDataDef m_pdd;

  protected void printBits(int[] bits) {
    for (int i=0;i<bits.length;i++) {
      getDebugging().print(bits[i]);
    }
    getDebugging().println();
  }

  protected void print(double[] bits) {
    for (int i=0;i<bits.length;i++) {
      getDebugging().print(i+":"+bits[i]+" ");
    }
    getDebugging().println();
  }

  @Override
  public Vector<int[]> getInitialSetups() {
    // TODO Auto-generated method stub
    Vector<int[]> ret=new Vector<int[]>();
    Vector<PackData> vpd=getDataSetups();
    for (PackData pd:vpd) {
      ret.add(pd.getBits());
      printBits(pd.getBits());
    }
    return(ret);
  }
  public void init(int ch) {
    m_pdd=getDataDef();
    init(ch,m_pdd.size());
  }



  public abstract PackDataDef getDataDef();

  public abstract Vector<PackData> getDataSetups();
}
