/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.WekaClassifierGenerator;
import adams.flow.transformer.AnyToCommandline;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class WekaClassifierGeneratorTest
extends AbstractFlowTest {
    public WekaClassifierGeneratorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public AbstractActor getActor() {
        WekaClassifierGenerator cg = (WekaClassifierGenerator)AbstractActor.forCommandLine((String)"adams.flow.source.WekaClassifierGenerator -setup \"weka.classifiers.trees.J48 -C 0.25 -M 2\" -parameter \"weka.core.setupgenerator.MathParameter -property confidenceFactor -min 0.1 -max 0.5 -step 0.1 -base 10.0 -expression I\"");
        AnyToCommandline a2c = new AnyToCommandline();
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{cg, a2c, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest(new File[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(WekaClassifierGeneratorTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaClassifierGeneratorTest.runTest((Test)WekaClassifierGeneratorTest.suite());
    }
}

