/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.container.WekaTrainTestSetContainer;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.sink.DumpFile;
import adams.flow.source.SingleFileSupplier;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaCrossValidationSplit;
import adams.flow.transformer.WekaFileReader;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;

public class WekaCrossValidationSplitTest
extends AbstractFlowTest {
    public WekaCrossValidationSplitTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("vote.arff");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public AbstractActor getActor() {
        SingleFileSupplier sfs = new SingleFileSupplier();
        sfs.setFile((PlaceholderFile)new TmpFile("vote.arff"));
        WekaFileReader fr = new WekaFileReader();
        WekaClassSelector cs = new WekaClassSelector();
        WekaCrossValidationSplit cvs = new WekaCrossValidationSplit();
        cvs.setRelationName("@-$T-$N");
        cvs.setFolds(3);
        cvs.setSeed(2L);
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{sfs, fr, cs, cvs, df});
        return flow;
    }

    public void testLOOCV() {
        Instances data;
        try {
            data = ConverterUtils.DataSource.read((String)new TmpFile("vote.arff").getAbsolutePath());
            data.setClassIndex(data.numAttributes() - 1);
        }
        catch (Exception e) {
            data = null;
            e.printStackTrace();
            WekaCrossValidationSplitTest.fail((String)"Failed to load test data 'vote.arff'!");
        }
        WekaCrossValidationSplitTest.assertNotNull((String)"No data loaded?", (Object)data);
        WekaCrossValidationSplit actor = new WekaCrossValidationSplit();
        actor.setFolds(-1);
        String result = actor.setUp();
        WekaCrossValidationSplitTest.assertNull((String)("setUp() of actor failed: " + result), (Object)result);
        actor.input(new Token((Object)data));
        result = actor.execute();
        WekaCrossValidationSplitTest.assertNull((String)("execute() of actor failed: " + result), (Object)result);
        int count = 0;
        while (actor.hasPendingOutput()) {
            Token output = actor.output();
            WekaCrossValidationSplitTest.assertNotNull((String)("No token produced? count=" + ++count), (Object)output);
            WekaTrainTestSetContainer cont = (WekaTrainTestSetContainer)output.getPayload();
            WekaCrossValidationSplitTest.assertNotNull((String)("No payload? count=" + count), (Object)cont);
            WekaCrossValidationSplitTest.assertEquals((String)"Test must have only 1 instance!", (int)1, (int)((Instances)cont.getValue("Test")).numInstances());
            WekaCrossValidationSplitTest.assertEquals((String)"Mismatch of overall instance count", (int)data.numInstances(), (int)(((Instances)cont.getValue("Train")).numInstances() + ((Instances)cont.getValue("Test")).numInstances()));
        }
        WekaCrossValidationSplitTest.assertEquals((String)"Number of data pairs differs", (int)data.numInstances(), (int)count);
    }

    public void testNoClassAttributeSet() {
        Instances data;
        try {
            data = ConverterUtils.DataSource.read((String)new TmpFile("vote.arff").getAbsolutePath());
        }
        catch (Exception e) {
            data = null;
            e.printStackTrace();
            WekaCrossValidationSplitTest.fail((String)"Failed to load test data 'vote.arff'!");
        }
        WekaCrossValidationSplitTest.assertNotNull((String)"No data loaded?", (Object)data);
        WekaCrossValidationSplit actor = new WekaCrossValidationSplit();
        String result = actor.setUp();
        WekaCrossValidationSplitTest.assertNull((String)("setUp() of actor failed: " + result), (Object)result);
        actor.input(new Token((Object)data));
        result = actor.execute();
        WekaCrossValidationSplitTest.assertNotNull((String)"execute() of actor must fail due to class attribute not set", (Object)result);
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.txt"));
    }

    public static Test suite() {
        return new TestSuite(WekaCrossValidationSplitTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaCrossValidationSplitTest.runTest((Test)WekaCrossValidationSplitTest.suite());
    }
}

