/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.core.EvaluationStatistic;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import weka.classifiers.Evaluation;

public class WekaEvaluationValuePicker
extends AbstractTransformer {
    private static final long serialVersionUID = -3113058781746945626L;
    protected EvaluationStatistic m_StatisticValue;
    protected int m_ClassIndex;

    public String globalInfo() {
        return "Picks a specific value from an evaluation object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("statistic", "statisticValue", (Object)EvaluationStatistic.PERCENT_CORRECT);
        this.m_OptionManager.add("index", "classIndex", (Object)1);
    }

    public void setStatisticValue(EvaluationStatistic value) {
        this.m_StatisticValue = value;
        this.reset();
    }

    public EvaluationStatistic getStatisticValue() {
        return this.m_StatisticValue;
    }

    public String statisticValueTipText() {
        return "The evaluation value to extract.";
    }

    public void setClassIndex(int value) {
        this.m_ClassIndex = value;
        this.reset();
    }

    public int getClassIndex() {
        return this.m_ClassIndex;
    }

    public String classIndexTipText() {
        return "The class label index (eg used for AUC).";
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("classIndex");
        String result = variable != null ? variable : "" + this.m_ClassIndex;
        result = result + ": ";
        variable = this.getOptionManager().getVariableForProperty("statisticValue");
        result = variable != null ? result + variable : result + (Object)((Object)this.m_StatisticValue);
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Evaluation.class};
    }

    protected String doExecute() {
        String result = null;
        double value = Double.NaN;
        Evaluation eval = (Evaluation)this.m_InputToken.getPayload();
        try {
            if (this.m_StatisticValue == EvaluationStatistic.NUMBER_CORRECT) {
                value = eval.correct();
            } else if (this.m_StatisticValue == EvaluationStatistic.NUMBER_INCORRECT) {
                value = eval.incorrect();
            } else if (this.m_StatisticValue == EvaluationStatistic.NUMBER_UNCLASSIFIED) {
                value = eval.unclassified();
            } else if (this.m_StatisticValue == EvaluationStatistic.PERCENT_CORRECT) {
                value = eval.pctCorrect();
            } else if (this.m_StatisticValue == EvaluationStatistic.PERCENT_INCORRECT) {
                value = eval.pctIncorrect();
            } else if (this.m_StatisticValue == EvaluationStatistic.PERCENT_UNCLASSIFIED) {
                value = eval.pctUnclassified();
            } else if (this.m_StatisticValue == EvaluationStatistic.KAPPA_STATISTIC) {
                value = eval.kappa();
            } else if (this.m_StatisticValue == EvaluationStatistic.MEAN_ABSOLUTE_ERROR) {
                value = eval.meanAbsoluteError();
            } else if (this.m_StatisticValue == EvaluationStatistic.ROOT_MEAN_SQUARED_ERROR) {
                value = eval.rootMeanSquaredError();
            } else if (this.m_StatisticValue == EvaluationStatistic.RELATIVE_ABSOLUTE_ERROR) {
                value = eval.relativeAbsoluteError();
            } else if (this.m_StatisticValue == EvaluationStatistic.ROOT_RELATIVE_SQUARED_ERROR) {
                value = eval.rootRelativeSquaredError();
            } else if (this.m_StatisticValue == EvaluationStatistic.CORRELATION_COEFFICIENT) {
                value = eval.correlationCoefficient();
            } else if (this.m_StatisticValue == EvaluationStatistic.SF_PRIOR_ENTROPY) {
                value = eval.SFPriorEntropy();
            } else if (this.m_StatisticValue == EvaluationStatistic.SF_SCHEME_ENTROPY) {
                value = eval.SFSchemeEntropy();
            } else if (this.m_StatisticValue == EvaluationStatistic.SF_ENTROPY_GAIN) {
                value = eval.SFEntropyGain();
            } else if (this.m_StatisticValue == EvaluationStatistic.SF_MEAN_PRIOR_ENTROPY) {
                value = eval.SFMeanPriorEntropy();
            } else if (this.m_StatisticValue == EvaluationStatistic.SF_MEAN_SCHEME_ENTROPY) {
                value = eval.SFMeanSchemeEntropy();
            } else if (this.m_StatisticValue == EvaluationStatistic.SF_MEAN_ENTROPY_GAIN) {
                value = eval.SFMeanEntropyGain();
            } else if (this.m_StatisticValue == EvaluationStatistic.KB_INFORMATION) {
                value = eval.KBInformation();
            } else if (this.m_StatisticValue == EvaluationStatistic.KB_MEAN_INFORMATION) {
                value = eval.KBMeanInformation();
            } else if (this.m_StatisticValue == EvaluationStatistic.KB_RELATIVE_INFORMATION) {
                value = eval.KBRelativeInformation();
            } else if (this.m_StatisticValue == EvaluationStatistic.TRUE_POSITIVE_RATE) {
                value = eval.truePositiveRate(this.m_ClassIndex);
            } else if (this.m_StatisticValue == EvaluationStatistic.NUM_TRUE_POSITIVES) {
                value = eval.numTruePositives(this.m_ClassIndex);
            } else if (this.m_StatisticValue == EvaluationStatistic.FALSE_POSITIVE_RATE) {
                value = eval.falsePositiveRate(this.m_ClassIndex);
            } else if (this.m_StatisticValue == EvaluationStatistic.NUM_FALSE_POSITIVES) {
                value = eval.numFalsePositives(this.m_ClassIndex);
            } else if (this.m_StatisticValue == EvaluationStatistic.TRUE_NEGATIVE_RATE) {
                value = eval.trueNegativeRate(this.m_ClassIndex);
            } else if (this.m_StatisticValue == EvaluationStatistic.NUM_TRUE_NEGATIVES) {
                value = eval.numTrueNegatives(this.m_ClassIndex);
            } else if (this.m_StatisticValue == EvaluationStatistic.FALSE_NEGATIVE_RATE) {
                value = eval.falseNegativeRate(this.m_ClassIndex);
            } else if (this.m_StatisticValue == EvaluationStatistic.NUM_FALSE_NEGATIVES) {
                value = eval.numFalseNegatives(this.m_ClassIndex);
            } else if (this.m_StatisticValue == EvaluationStatistic.IR_PRECISION) {
                value = eval.precision(this.m_ClassIndex);
            } else if (this.m_StatisticValue == EvaluationStatistic.IR_RECALL) {
                value = eval.recall(this.m_ClassIndex);
            } else if (this.m_StatisticValue == EvaluationStatistic.F_MEASURE) {
                value = eval.fMeasure(this.m_ClassIndex);
            } else if (this.m_StatisticValue == EvaluationStatistic.AREA_UNDER_ROC) {
                value = eval.areaUnderROC(this.m_ClassIndex);
            }
            this.m_OutputToken = new Token((Object)value);
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace((Throwable)e);
            result = "Error retrieving value for '" + (Object)((Object)this.m_StatisticValue) + "':\n" + e;
        }
        return result;
    }

    public Class[] generates() {
        return new Class[]{Double.class};
    }
}

