/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.core.Token;
import adams.flow.transformer.AbstractWekaInstanceAndWekaInstancesTransformer;
import weka.core.Instance;
import weka.core.Instances;

public class WekaRenameRelation
extends AbstractWekaInstanceAndWekaInstancesTransformer {
    private static final long serialVersionUID = 5071747277597147724L;
    protected String m_Find;
    protected String m_Replace;

    public String globalInfo() {
        return "Modifies relation names.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("find", "find", (Object)"([\\s\\S]+)");
        this.m_OptionManager.add("replace", "replace", (Object)"$0");
    }

    public String getQuickInfo() {
        String result = "find: ";
        String variable = this.getOptionManager().getVariableForProperty("find");
        result = variable != null ? result + variable : result + this.m_Find;
        result = result + ", replace: ";
        variable = this.getOptionManager().getVariableForProperty("replace");
        result = variable != null ? result + variable : result + this.m_Replace;
        return result;
    }

    public void setFind(String value) {
        this.m_Find = value;
        this.reset();
    }

    public String getFind() {
        return this.m_Find;
    }

    public String findTipText() {
        return "The regular expression to replace (use '[\\s\\S]+' to match whole string).";
    }

    public void setReplace(String value) {
        this.m_Replace = value;
        this.reset();
    }

    public String getReplace() {
        return this.m_Replace;
    }

    public String replaceTipText() {
        return "The replacement string.";
    }

    protected String doExecute() {
        Instances data;
        Instance inst;
        String result = null;
        if (this.m_InputToken.getPayload() instanceof Instance) {
            inst = (Instance)this.m_InputToken.getPayload();
            data = inst.dataset();
        } else if (this.m_InputToken.getPayload() instanceof adams.data.instance.Instance) {
            inst = ((adams.data.instance.Instance)((Object)this.m_InputToken.getPayload())).toInstance();
            data = inst.dataset();
        } else {
            inst = null;
            data = (Instances)this.m_InputToken.getPayload();
        }
        if (this.isDebugOn()) {
            this.debug("Renaming: " + this.m_Find + " -> " + this.m_Replace);
        }
        if (data != null) {
            String oldName = data.relationName();
            String newName = oldName.replaceAll(this.m_Find, this.m_Replace);
            data.setRelationName(newName);
            if (this.isDebugOn()) {
                this.debug("Renamed: " + oldName + " -> " + newName);
            }
        } else if (this.isDebugOn()) {
            this.debug("weka.core.Instance doesn't have access to dataset?");
        }
        if (inst == null) {
            this.m_OutputToken = new Token((Object)data);
        } else if (this.m_InputToken.getPayload() instanceof adams.data.instance.Instance) {
            adams.data.instance.Instance instA = new adams.data.instance.Instance();
            instA.set(inst);
            this.m_OutputToken = new Token((Object)instA);
        } else {
            this.m_OutputToken = new Token((Object)inst);
        }
        return result;
    }
}

