/*
 * TreeVisualizer.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 *
 */

package adams.gui.menu;

import java.io.File;
import java.io.FileReader;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

import weka.gui.treevisualizer.Node;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeBuild;
import adams.core.io.PlaceholderFile;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.ChildFrame;
import adams.gui.application.UserMode;

/**
 * Displays data in the tree visualizer.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2819 $
 * @see weka.gui.treevisualizer.TreeVisualizer
 */
public class TreeVisualizer
  extends AbstractParameterHandlingWekaMenuItemDefinition {

  /** for serialization. */
  private static final long serialVersionUID = -771667287275117680L;

  /** filechooser for TreeVisualizers. */
  protected JFileChooser m_FileChooser;

  /**
   * Initializes the menu item.
   *
   * @param owner	the owning application
   */
  public TreeVisualizer(AbstractApplicationFrame owner) {
    super(owner);
  }

  /**
   * Initializes members.
   */
  protected void initialize() {
    super.initialize();

    m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
  }

  /**
   * Launches the functionality of the menu item.
   */
  public void launch() {
    String filename;
    if (m_Parameters.length == 0) {
      // choose file
      int retVal = m_FileChooser.showOpenDialog(getOwner());
      if (retVal != JFileChooser.APPROVE_OPTION)
	return;
      filename = m_FileChooser.getSelectedFile().getAbsolutePath();
    }
    else {
      filename = new PlaceholderFile(m_Parameters[0]).getAbsolutePath();
    }

    // build tree
    TreeBuild builder = new TreeBuild();
    Node top = null;
    NodePlace arrange = new PlaceNode2();
    try {
      top = builder.create(new FileReader(filename));
    }
    catch (Exception e) {
      e.printStackTrace();
      JOptionPane.showMessageDialog(
	  getOwner(), "Error loading file '" + filename + "':\n" + e.getMessage());
      return;
    }

    // create frame
    ChildFrame frame = createChildFrame(
	new weka.gui.treevisualizer.TreeVisualizer(null, top, arrange), 800, 600);
    frame.setTitle(frame.getTitle()  + " - " + filename);
  }

  /**
   * Returns the title of the window (and text of menuitem).
   *
   * @return 		the title
   */
  public String getTitle() {
    return "TreeVisualizer";
  }

  /**
   * Whether the panel can only be displayed once.
   *
   * @return		true if the panel can only be displayed once
   */
  public boolean isSingleton() {
    return false;
  }

  /**
   * Returns the user mode, which determines visibility as well.
   *
   * @return		the user mode
   */
  public UserMode getUserMode() {
    return UserMode.BASIC;
  }
}