/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Range;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.Vector;
import weka.core.Instance;

public class WekaInstanceStreamPlotGenerator
extends AbstractTransformer {
    private static final long serialVersionUID = 6449128249417195569L;
    protected Range m_Attributes;
    protected Vector<SequencePlotterContainer> m_Containers;
    protected int m_Counter;

    public String globalInfo() {
        return "Generates plot containers from a range of attributes of the weka.core.Instance objects being passed through.\nThe generator merely uses the internal data representation for generating the Y value of the plot container.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("attributes", "attributes", (Object)"first-last");
    }

    protected void initialize() {
        super.initialize();
        this.m_Attributes = new Range();
        this.m_Containers = new Vector();
    }

    protected void reset() {
        super.reset();
        this.m_Containers.clear();
        this.m_Counter = 0;
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("attributes");
        if (variable != null) {
            return variable;
        }
        return this.m_Attributes.getRange();
    }

    public void setAttributes(String value) {
        this.m_Attributes.setRange(value);
        this.reset();
    }

    public String getAttributes() {
        return this.m_Attributes.getRange();
    }

    public String attributesTipText() {
        return "The range of attributes to create plot containers for; " + this.m_Attributes.getExample();
    }

    public Class[] accepts() {
        return new Class[]{Instance.class};
    }

    protected String doExecute() {
        String result = null;
        Instance inst = (Instance)this.m_InputToken.getPayload();
        ++this.m_Counter;
        this.m_Containers.clear();
        this.m_Attributes.setMax(inst.numAttributes());
        int[] indices = this.m_Attributes.getIntIndices();
        for (int i = 0; i < indices.length; ++i) {
            SequencePlotterContainer cont = new SequencePlotterContainer(indices[i] + "." + inst.dataset().relationName(), new Double(this.m_Counter), Double.valueOf(inst.value(indices[i])));
            this.m_Containers.add(cont);
        }
        return result;
    }

    public Class[] generates() {
        return new Class[]{SequencePlotterContainer.class};
    }

    public boolean hasPendingOutput() {
        return this.m_Containers != null && this.m_Containers.size() > 0;
    }

    public Token output() {
        Token result = new Token((Object)this.m_Containers.firstElement());
        this.m_InputToken = null;
        this.m_Containers.remove(0);
        return result;
    }
}

