/**
 * IDGeneratorPostProcessorTest.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */
package adams.data.id;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.env.Environment;

/**
 * Test class for the IDGeneratorPostProcessor filter. Run from the command line with: <p/>
 * java adams.data.filter.IDGeneratorPostProcessorTest
 * <p/>
 * Note: dummy test
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2819 $
 */
public class IDGeneratorPostProcessorTest
  extends AbstractInstanceIDGeneratorTestCase {

  /**
   * Constructs the test case. Called by subclasses.
   *
   * @param name 	the name of the test
   */
  public IDGeneratorPostProcessorTest(String name) {
    super(name);
  }

  /**
   * Returns the filenames (without path) of the input data files to use
   * in the regression test.
   *
   * @return		the filenames
   */
  protected String[] getRegressionInputFiles() {
    return new String[] {
	"bolts.arff",
	"bolts.arff",
	"bolts.arff"
    };
  }

  /**
   * Returns the setups to use in the regression test.
   *
   * @return		the setups
   */
  protected AbstractIDGenerator[] getRegressionSetups() {
    IDGeneratorPostProcessor[]	result;
    SimpleIDGenerator		simple;

    result = new IDGeneratorPostProcessor[3];

    result[0] = new IDGeneratorPostProcessor();

    simple = new SimpleIDGenerator();
    simple.setFormat("{ID}");
    simple.setFilenameReplaceChar("_");
    simple.setMakeFilename(true);
    result[1] = new IDGeneratorPostProcessor();
    result[1].setGenerator(simple);
    result[1].setFind("\\.arff");
    result[1].setReplace("");

    simple = new SimpleIDGenerator();
    simple.setFilenameReplaceChar("_");
    simple.setMakeFilename(true);
    result[2] = new IDGeneratorPostProcessor();
    result[2].setGenerator(simple);
    result[2].setFind("\\.arff");
    result[2].setReplace("");

    return result;
  }

  /**
   * Returns the test suite.
   *
   * @return		the suite
   */
  public static Test suite() {
    return new TestSuite(IDGeneratorPostProcessorTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
