/**
 * MultiOutlierDetectorTest.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */
package adams.data.outlier;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.data.instance.Instance;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.env.Environment;

/**
 * Test class for the MultiOutlierDetector outlier detector. Run from the command line with: <p/>
 * java adams.data.outlier.MultiOutlierDetectorTest
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2819 $
 */
public class MultiOutlierDetectorTest
  extends AbstractInstanceOutlierDetectorTestCase {

  /**
   * Constructs the test case. Called by subclasses.
   *
   * @param name 	the name of the test
   */
  public MultiOutlierDetectorTest(String name) {
    super(name);
  }

  /**
   * Returns the filenames (without path) of the input data files to use
   * in the regression test.
   *
   * @return		the filenames
   */
  protected String[] getRegressionInputFiles() {
    return new String[] {
	"vote1.arff",
	"vote2.arff",
    };
  }

  /**
   * Returns the setups to use in the regression test.
   *
   * @return		the setups
   */
  protected AbstractOutlierDetector[] getRegressionSetups() {
    MultiOutlierDetector[]	result;
    PassThrough			pass;
    TargetRequired		target;

    result = new MultiOutlierDetector[2];

    result[0] = new MultiOutlierDetector();

    pass   = new PassThrough();
    target = new TargetRequired();
    target.setField(new Field(Instance.REPORT_CLASS, DataType.NUMERIC));
    result[1] = new MultiOutlierDetector();
    result[1].setSubDetectors(new AbstractOutlierDetector[]{pass, target});

    return result;
  }

  /**
   * Returns the test suite.
   *
   * @return		the suite
   */
  public static Test suite() {
    return new TestSuite(MultiOutlierDetectorTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
