/*
 * GlobalTransformerTest.java
 * Copyright (C) 2009-2010 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.transformer;

import java.io.File;

import junit.framework.Test;
import junit.framework.TestSuite;
import weka.filters.unsupervised.attribute.Remove;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Branch;
import adams.flow.control.Flow;
import adams.flow.control.Sequence;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorReference;
import adams.flow.standalone.GlobalActors;
import adams.flow.source.SingleFileSupplier;
import adams.test.TmpFile;

/**
 * Tests the GlobalTransformer by using one WekaFilter actor from two
 * branches of a Branch actor.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3130 $
 */
public class GlobalTransformerTest
  extends AbstractFlowTest {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public GlobalTransformerTest(String name) {
    super(name);
  }

  /**
   * Called by JUnit before each test method. Copies some resource files into
   * the tmp directory
   *
   * @throws Exception if an error occurs reading the example instances.
   */
  protected void setUp() throws Exception {
    super.setUp();

    m_TestHelper.copyResourceToTmp("vote.arff");
    m_TestHelper.deleteFileFromTmp("dumpfile1.arff");
    m_TestHelper.deleteFileFromTmp("dumpfile2.arff");
  }

  /**
   * Called by JUnit after each test method.
   *
   * @throws Exception	if tear-down fails
   */
  protected void tearDown() throws Exception {
    m_TestHelper.deleteFileFromTmp("vote.arff");
    m_TestHelper.deleteFileFromTmp("dumpfile1.arff");
    m_TestHelper.deleteFileFromTmp("dumpfile2.arff");

    super.tearDown();
  }

  /**
   * Used to create an instance of a specific actor.
   *
   * @return a suitably configured <code>AbstractActor</code> value
   */
  public AbstractActor getActor() {
    SingleFileSupplier sfs = new SingleFileSupplier();
    sfs.setFile(new TmpFile("vote.arff"));

    WekaFileReader fr = new WekaFileReader();
    fr.setIncremental(true);

    WekaFilter wf = new WekaFilter();
    wf.setInitializeOnce(false);
    wf.setFilter(new weka.filters.unsupervised.attribute.Add());
    wf.setName("global-wf");

    GlobalActors gas = new GlobalActors();
    gas.setActors(new AbstractActor[]{wf});

    WekaFilter wf1 = new WekaFilter();
    Remove rem1 = new Remove();
    rem1.setAttributeIndices("1");
    wf1.setFilter(rem1);

    GlobalTransformer gt1 = new GlobalTransformer();
    gt1.setGlobalName(new GlobalActorReference("global-wf"));

    WekaRenameRelation ren1 = new WekaRenameRelation();
    ren1.setFind("[\\s\\S]+");
    ren1.setReplace("blah1");

    WekaInstanceDumper id1 = new WekaInstanceDumper();
    id1.setOutputPrefix(new TmpFile("dumpfile1"));

    Sequence sq1 = new Sequence();
    sq1.setActors(new AbstractActor[]{wf1, gt1, ren1, id1});

    WekaFilter wf2 = new WekaFilter();
    Remove rem2 = new Remove();
    rem2.setAttributeIndices("2");
    wf2.setFilter(rem2);

    GlobalTransformer gt2 = new GlobalTransformer();
    gt2.setGlobalName(new GlobalActorReference("global-wf"));

    WekaRenameRelation ren2 = new WekaRenameRelation();
    ren2.setFind("[\\s\\S]+");
    ren2.setReplace("blah2");

    WekaInstanceDumper id2 = new WekaInstanceDumper();
    id2.setOutputPrefix(new TmpFile("dumpfile2"));

    Sequence sq2 = new Sequence();
    sq2.setActors(new AbstractActor[]{wf2, gt2, ren2, id2});

    Branch br = new Branch();
    //br.setNumThreads(0);
    br.setBranches(new AbstractActor[]{sq1, sq2});

    Flow flow = new Flow();
    flow.setActors(new AbstractActor[]{gas, sfs, fr, br});

    return flow;
  }

  /**
   * Performs a regression test, comparing against previously generated output.
   */
  public void testRegression() {
    performRegressionTest(
	new File[]{
	    new TmpFile("dumpfile1.arff"),
	    new TmpFile("dumpfile2.arff")});
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(GlobalTransformerTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(adams.env.Environment.class);
    runTest(suite());
  }
}
