/*
 * WekaClassifierRankerTest.java
 * Copyright (C) 2010-2011 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.transformer;

import junit.framework.Test;
import junit.framework.TestSuite;
import weka.core.setupgenerator.AbstractParameter;
import weka.core.setupgenerator.MathParameter;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorReference;
import adams.flow.standalone.GlobalActors;
import adams.flow.sink.DumpFile;
import adams.flow.source.WekaClassifierGenerator;
import adams.flow.source.SequenceSource;
import adams.flow.source.SingleFileSupplier;
import adams.flow.transformer.WekaClassifierRanker.Measure;
import adams.test.TmpFile;

/**
 * Tests the WekaClassifierRanker actor.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2909 $
 */
public class WekaClassifierRankerTest
  extends AbstractFlowTest {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public WekaClassifierRankerTest(String name) {
    super(name);
  }

  /**
   * Called by JUnit before each test method.
   *
   * @throws Exception if an error occurs reading the example instances.
   */
  protected void setUp() throws Exception {
    super.setUp();

    m_TestHelper.copyResourceToTmp("vote.arff");
    m_TestHelper.deleteFileFromTmp("dumpfile.txt");
  }

  /**
   * Called by JUnit after each test method.
   *
   * @throws Exception	if tear-down fails
   */
  protected void tearDown() throws Exception {
    m_TestHelper.deleteFileFromTmp("vote.arff");
    m_TestHelper.deleteFileFromTmp("dumpfile.txt");

    super.tearDown();
  }

  /**
   * Used to create an instance of a specific actor.
   *
   * @return a suitably configured <code>AbstractActor</code> value
   */
  public AbstractActor getActor() {
    SingleFileSupplier sfs = new SingleFileSupplier();
    sfs.setFile(new TmpFile("vote.arff"));

    WekaFileReader fr = new WekaFileReader();

    WekaClassSelector cs = new WekaClassSelector();

    SequenceSource seq = new SequenceSource();
    seq.setName("dataset");
    seq.setActors(new AbstractActor[]{
	sfs,
	fr,
	cs
    });

    GlobalActors ga = new GlobalActors();
    ga.setActors(new AbstractActor[]{
	seq
    });

    WekaClassifierGenerator cg = new WekaClassifierGenerator();
    cg.setOutputArray(true);
    cg.setSetup(new weka.classifiers.trees.J48());
    MathParameter param = new MathParameter();
    param.setProperty("confidenceFactor");
    param.setBase(10.0);
    param.setMin(0.1);
    param.setMax(0.5);
    param.setStep(0.1);
    cg.setParameters(new AbstractParameter[]{
	param
    });

    WekaClassifierRanker cr = new WekaClassifierRanker();
    cr.setMax(3);
    cr.setFolds(10);
    cr.setMeasure(Measure.ACC);
    cr.setTrain(new GlobalActorReference("dataset"));

    ArrayToSequence a2s = new ArrayToSequence();

    AnyToCommandline a2c = new AnyToCommandline();

    DumpFile df = new DumpFile();
    df.setAppend(true);
    df.setOutputFile(new TmpFile("dumpfile.txt"));

    Flow flow = new Flow();
    flow.setActors(new AbstractActor[]{ga, cg, cr, a2s, a2c, df});

    return flow;
  }

  /**
   * Performs a regression test, comparing against previously generated output.
   */
  public void testRegression() {
    performRegressionTest(
	new TmpFile("dumpfile.txt"));
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(WekaClassifierRankerTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
