/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseRegExp;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.SingleFileSupplier;
import adams.flow.transformer.WekaAttributeIterator;
import adams.flow.transformer.WekaFileReader;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ArffLoader;

public class WekaAttributeIteratorTest
extends AbstractFlowTest {
    public WekaAttributeIteratorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("anneal_train.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("anneal_train.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(WekaAttributeIteratorTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            AbstractArgumentOption argOption = (AbstractArgumentOption)flow.getOptionManager().findByProperty("actors");
            AbstractActor[] tmp1 = new AbstractActor[4];
            SingleFileSupplier tmp2 = new SingleFileSupplier();
            argOption = (AbstractArgumentOption)tmp2.getOptionManager().findByProperty("file");
            tmp2.setFile((PlaceholderFile)argOption.valueOf("${TMP}/anneal_train.arff"));
            tmp1[0] = tmp2;
            WekaFileReader tmp4 = new WekaFileReader();
            argOption = (AbstractArgumentOption)tmp4.getOptionManager().findByProperty("customLoader");
            ArffLoader tmp6 = new ArffLoader();
            tmp4.setCustomLoader((AbstractFileLoader)tmp6);
            tmp1[1] = tmp4;
            WekaAttributeIterator tmp7 = new WekaAttributeIterator();
            argOption = (AbstractArgumentOption)tmp7.getOptionManager().findByProperty("range");
            tmp7.setRange((String)argOption.valueOf("5-last"));
            argOption = (AbstractArgumentOption)tmp7.getOptionManager().findByProperty("regExp");
            tmp7.setRegExp((BaseRegExp)argOption.valueOf(".*s.*"));
            tmp1[2] = tmp7;
            DumpFile tmp10 = new DumpFile();
            argOption = (AbstractArgumentOption)tmp10.getOptionManager().findByProperty("outputFile");
            tmp10.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.txt"));
            tmp10.setAppend(true);
            tmp1[3] = tmp10;
            flow.setActors(tmp1);
        }
        catch (Exception e) {
            WekaAttributeIteratorTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaAttributeIteratorTest.runTest((Test)WekaAttributeIteratorTest.suite());
    }
}

