/*
 * WekaExperimentFile.java
 * Copyright (C) 2009-2011 University of Waikato, Hamilton, New Zealand
 */

package adams.data;

import java.io.File;
import java.net.URI;

import adams.core.io.PlaceholderFile;

/**
 * A dummy class for the GOE, for special handling of experiments.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2823 $
 */
public class WekaExperimentFile
  extends PlaceholderFile {

  /** for serialization. */
  private static final long serialVersionUID = -4345693975779199292L;

  /**
   * Creates a new ExperimentFile instance from a parent abstract pathname and a child
   * pathname string.
   *
   * @param parent	the parent
   * @param child	the child
   */
  public WekaExperimentFile(File parent, String child) {
    super(parent, child);
  }

  /**
   * Creates a new ExperimentFile instance by converting the given pathname string into
   * an abstract pathname.
   *
   * @param pathname	the path
   */
  public WekaExperimentFile(String pathname) {
    super(pathname);
  }

  /**
   * Creates a new ExperimentFile instance from a parent pathname string and a child
   * pathname string.
   *
   * @param parent	the parent
   * @param child	the child
   */
  public WekaExperimentFile(String parent, String child) {
    super(parent, child);
  }

  /**
   * Creates a new ExperimentFile instance by converting the given file: URI into an
   * abstract pathname.
   *
   * @param uri		the identifier
   */
  public WekaExperimentFile(URI uri) {
    super(uri);
  }

  /**
   * Creates a new ExperimentFile instance by using the given file.
   *
   * @param file	the file to use
   */
  public WekaExperimentFile(File file) {
    super(file.getAbsolutePath());
  }

  /**
   * Returns a file object.
   *
   * @return		the file
   */
  public File toFile() {
    return new File(getPath());
  }
}
