/**
 * PassThrough.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.data.weka.evaluator;

import weka.core.Instance;

/**
 <!-- globalinfo-start -->
 * A dummy evaluator that OKs all data.
 * <p/>
 <!-- globalinfo-end -->
 *
 <!-- options-start -->
 * Valid options are: <p/>
 *
 * <pre>-D (property: debug)
 * &nbsp;&nbsp;&nbsp;If set to true, scheme may output additional info to the console.
 * </pre>
 *
 <!-- options-end -->
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 574 $
 */
public class PassThrough
  extends AbstractInstanceEvaluator {

  /** for serialization. */
  private static final long serialVersionUID = -8364993668286801038L;

  /**
   * Returns a string describing the object.
   *
   * @return 		a description suitable for displaying in the gui
   */
  public String globalInfo() {
    return "A dummy evaluator that OKs all data.";
  }

  /**
   * Performs no real evaluation, just returns 1.0.
   *
   * @param inst	the instance to evaluate
   * @return		evaluation range, between 0 and 1 (0 = bad, 1 = good, -1 = if unable to evaluate)
   */
  protected double doEvaluate(Instance inst) {
    return 1.0;
  }
}
