/*
 * WekaModelContainer.java
 * Copyright (C) 2009-2011 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.container;

import weka.core.Instances;

import java.util.Enumeration;
import java.util.Vector;

/**
 * A container for models (e.g., classifier or clusterer) and an optional
 * header of a dataset.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3245 $
 */
public class WekaModelContainer
  extends AbstractContainer {

  /** for serialization. */
  private static final long serialVersionUID = 5581530171877321061L;

  /** the identifier for the Model. */
  public final static String VALUE_MODEL = "Model";

  /** the identifier for the Header. */
  public final static String VALUE_HEADER = "Header";

  /**
   * Initializes the container.
   * <p/>
   * Only used for generating help information.
   */
  public WekaModelContainer() {
    this(null);
  }

  /**
   * Initializes the container with no header.
   *
   * @param model	the model to use
   */
  public WekaModelContainer(Object model) {
    this(model, null);
  }

  /**
   * Initializes the container with no header.
   *
   * @param model	the model to use
   * @param header	the header to use
   */
  public WekaModelContainer(Object model, Instances header) {
    super();

    store(VALUE_MODEL, model);
    store(VALUE_HEADER, header);
  }

  /**
   * Returns all value names that can be used (theoretically).
   *
   * @return		enumeration over all possible value names
   */
  public Enumeration<String> names() {
    Vector<String>	result;

    result = new Vector<String>();

    result.add(VALUE_MODEL);
    result.add(VALUE_HEADER);

    return result.elements();
  }

  /**
   * Checks whether the setup of the container is valid.
   *
   * @return		true if all the necessary values are available
   */
  public boolean isValid() {
    return   (hasValue(VALUE_MODEL) && !hasValue(VALUE_HEADER))
           | (hasValue(VALUE_MODEL) &&  hasValue(VALUE_HEADER));
  }
}
