/*
 * WekaPredictionContainer.java
 * Copyright (C) 2009-2011 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.container;

import weka.core.Instance;
import weka.core.Utils;

import java.util.Enumeration;
import java.util.Vector;

/**
 * A container for predictions made by a classifier.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4015 $
 */
public class WekaPredictionContainer
  extends AbstractContainer {

  /** for serialization. */
  private static final long serialVersionUID = 872330681430825295L;

  /** the identifier for the Instance. */
  public final static String VALUE_INSTANCE = "Instance";

  /** the identifier for the Classification. */
  public final static String VALUE_CLASSIFICATION = "Classification";

  /** the identifier for the Classification's label. */
  public final static String VALUE_CLASSIFICATION_LABEL = "Classification label";

  /** the identifier for the Distribution. */
  public final static String VALUE_DISTRIBUTION = "Distribution";

  /**
   * Initializes the container.
   * <p/>
   * Only used for generating help information.
   */
  public WekaPredictionContainer() {
    this(null, Utils.missingValue(), new double[0]);
  }

  /**
   * Initializes the container.
   *
   * @param inst	the instance that was used for prediction
   * @param cls		the classification
   * @param dist	the class distribution
   */
  public WekaPredictionContainer(Instance inst, double cls, double[] dist) {
    super();

    if (inst != null)
      store(VALUE_INSTANCE, (Instance) inst.copy());
    store(VALUE_CLASSIFICATION, cls);
    store(VALUE_DISTRIBUTION, dist.clone());
    if ((inst != null) && inst.classAttribute().isNominal())
      store(VALUE_CLASSIFICATION_LABEL, inst.classAttribute().value((int) cls));
  }

  /**
   * Returns all value names that can be used (theoretically).
   *
   * @return		enumeration over all possible value names
   */
  public Enumeration<String> names() {
    Vector<String>	result;

    result = new Vector<String>();

    result.add(VALUE_INSTANCE);
    result.add(VALUE_CLASSIFICATION);
    result.add(VALUE_CLASSIFICATION_LABEL);
    result.add(VALUE_DISTRIBUTION);

    return result.elements();
  }

  /**
   * Checks whether the setup of the container is valid.
   *
   * @return		true if all the necessary values are available
   */
  public boolean isValid() {
    return   (hasValue(VALUE_INSTANCE) && hasValue(VALUE_CLASSIFICATION) && hasValue(VALUE_DISTRIBUTION) && !hasValue(VALUE_CLASSIFICATION_LABEL))
           | (hasValue(VALUE_INSTANCE) && hasValue(VALUE_CLASSIFICATION) && hasValue(VALUE_DISTRIBUTION) &&  hasValue(VALUE_CLASSIFICATION_LABEL));
  }
}
