/*
 * AbstractModelWriter.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.sink;

import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Vector;

import adams.flow.container.WekaModelContainer;

/**
 * Ancestor for actors that serialize models.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3172 $
 */
public abstract class AbstractWekaModelWriter
  extends AbstractFileWriter {

  /** for serialization. */
  private static final long serialVersionUID = -259222073894194923L;

  /**
   * Returns the tip text for this property.
   *
   * @return 		tip text for this property suitable for
   * 			displaying in the GUI or for listing the options.
   */
  public String outputFileTipText() {
    return "The filename to save the model (and optional header) in.";
  }

  /**
   * Returns the class that the consumer accepts.
   *
   * @return		adams.flow.container.WekaModelContainer.class + additional classes
   * @see		#getAdditionalAcceptedClasses()
   */
  public Class[] accepts() {
    Vector<Class>	result;

    result = new Vector<Class>();
    result.add(WekaModelContainer.class);
    result.addAll(Arrays.asList(getAdditionalAcceptedClasses()));

    return result.toArray(new Class[result.size()]);
  }

  /**
   * Returns additional classes that are accepted as input.
   * <p/>
   * Default implementation returns a zero-length array.
   *
   * @return		the additional classes
   */
  protected Class[] getAdditionalAcceptedClasses() {
    return new Class[0];
  }

  /**
   * Executes the flow item.
   *
   * @return		null if everything is fine, otherwise error message
   */
  protected String doExecute() {
    String		result;
    ObjectOutputStream	oos;
    WekaModelContainer	cont;

    result = null;

    try {
      oos = new ObjectOutputStream(new FileOutputStream(m_OutputFile.getAbsolutePath()));
      if (m_InputToken.getPayload() instanceof WekaModelContainer) {
	cont = (WekaModelContainer) m_InputToken.getPayload();
	oos.writeObject(cont.getValue(WekaModelContainer.VALUE_MODEL));
	if (cont.hasValue(WekaModelContainer.VALUE_HEADER))
	  oos.writeObject(cont.getValue(WekaModelContainer.VALUE_HEADER));
      }
      else {
	oos.writeObject(m_InputToken.getPayload());
      }
      oos.flush();
      oos.close();
    }
    catch (Exception e) {
      result = e.toString();
      getSystemErr().println("Failed to serialize model data to '" + m_OutputFile + "':");
      getSystemErr().printStackTrace(e);
    }

    return result;
  }
}
