/*
 * BoundaryVisualizer.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 *
 */

package adams.gui.menu;

import java.io.File;

import javax.swing.JFileChooser;

import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.UserMode;

/**
 * Displays data in the boundary visualizer.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4568 $
 * @see weka.gui.boundaryvisualizer.BoundaryVisualizer
 */
public class BoundaryVisualizer
  extends AbstractWekaMenuItemDefinition {

  /** for serialization. */
  private static final long serialVersionUID = -771667287275117680L;

  /** filechooser for BoundaryVisualizers. */
  protected JFileChooser m_FileChooser;

  /**
   * Initializes the menu item with no owner.
   */
  public BoundaryVisualizer() {
    this(null);
  }

  /**
   * Initializes the menu item.
   *
   * @param owner	the owning application
   */
  public BoundaryVisualizer(AbstractApplicationFrame owner) {
    super(owner);
  }

  /**
   * Initializes members.
   */
  protected void initialize() {
    super.initialize();

    m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
  }

  /**
   * Launches the functionality of the menu item.
   */
  public void launch() {
    createChildFrame(new weka.gui.boundaryvisualizer.BoundaryVisualizer(), 800, 600);
    weka.gui.boundaryvisualizer.BoundaryVisualizer.setExitIfNoWindowsOpen(false);
  }

  /**
   * Returns the title of the window (and text of menuitem).
   *
   * @return 		the title
   */
  public String getTitle() {
    return "BoundaryVisualizer";
  }

  /**
   * Whether the panel can only be displayed once.
   *
   * @return		true if the panel can only be displayed once
   */
  public boolean isSingleton() {
    return false;
  }

  /**
   * Returns the user mode, which determines visibility as well.
   *
   * @return		the user mode
   */
  public UserMode getUserMode() {
    return UserMode.BASIC;
  }
}