/*
 * Explorer.java
 * Copyright (C) 2009-2011 University of Waikato, Hamilton, New Zealand
 *
 */

package adams.gui.menu;

import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ConverterUtils;
import adams.core.io.PlaceholderFile;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.UserMode;

/**
 * Opens the WEKA Explorer.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4568 $
 */
public class Explorer
  extends AbstractParameterHandlingWekaMenuItemDefinition {

  /** for serialization. */
  private static final long serialVersionUID = 3941702242700593202L;

  /**
   * Initializes the menu item with no owner.
   */
  public Explorer() {
    this(null);
  }

  /**
   * Initializes the menu item.
   *
   * @param owner	the owning application
   */
  public Explorer(AbstractApplicationFrame owner) {
    super(owner);
  }

  /**
   * Launches the functionality of the menu item.
   */
  public void launch() {
    weka.gui.explorer.Explorer explorer = new weka.gui.explorer.Explorer();
    createChildFrame(explorer, 800, 600);
    if (m_Parameters.length > 0) {
      PlaceholderFile file = new PlaceholderFile(m_Parameters[0]);
      try {
	AbstractFileLoader loader = ConverterUtils.getLoaderForFile(file.getAbsolutePath());
	loader.setFile(file.getAbsoluteFile());
	explorer.getPreprocessPanel().setInstancesFromFile(loader);
      }
      catch (Exception e) {
	getSystemErr().println("Failed to open file: " + m_Parameters[0]);
	getSystemErr().printStackTrace(e);
      }
    }
  }

  /**
   * Returns the title of the window (and text of menuitem).
   *
   * @return 		the title
   */
  public String getTitle() {
    return "Explorer";
  }

  /**
   * Whether the panel can only be displayed once.
   *
   * @return		true if the panel can only be displayed once
   */
  public boolean isSingleton() {
    return false;
  }

  /**
   * Returns the user mode, which determines visibility as well.
   *
   * @return		the user mode
   */
  public UserMode getUserMode() {
    return UserMode.BASIC;
  }
}