/*
 * InstanceCompare.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 *
 */

package adams.gui.menu;

import adams.core.io.PlaceholderFile;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.UserMode;
import adams.gui.visualization.instance.InstanceComparePanel;

/**
 * For comparing two datasets visually.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4568 $
 */
public class InstanceCompare
  extends AbstractParameterHandlingWekaMenuItemDefinition {

  /** for serialization. */
  private static final long serialVersionUID = 7586443345167287461L;

  /**
   * Initializes the menu item with no owner.
   */
  public InstanceCompare() {
    this(null);
  }

  /**
   * Initializes the menu item.
   *
   * @param owner	the owning application
   */
  public InstanceCompare(AbstractApplicationFrame owner) {
    super(owner);
  }

  /**
   * Returns the file name of the icon.
   *
   * @return		the filename or null if no icon available
   */
  public String getIconName() {
    return "compare.gif";
  }

  /**
   * Launches the functionality of the menu item.
   */
  public void launch() {
    InstanceComparePanel panel = new InstanceComparePanel();
    createChildFrame(panel, 1000, 800);
    if (m_Parameters.length > 0)
      panel.setFirstDataset(new PlaceholderFile(m_Parameters[0]));
    if (m_Parameters.length > 1)
      panel.setSecondDataset(new PlaceholderFile(m_Parameters[1]));
  }

  /**
   * Returns the title of the window (and text of menuitem).
   *
   * @return 		the title
   */
  public String getTitle() {
    return "Instance Compare";
  }

  /**
   * Whether the panel can only be displayed once.
   *
   * @return		true if the panel can only be displayed once
   */
  public boolean isSingleton() {
    return false;
  }

  /**
   * Returns the user mode, which determines visibility as well.
   *
   * @return		the user mode
   */
  public UserMode getUserMode() {
    return UserMode.BASIC;
  }
}