/*
 * InstanceContainerModel.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.instance;

import adams.gui.visualization.container.ContainerListManager;
import adams.gui.visualization.container.ContainerModel;

/**
 * A model for displaying the currently loaded Instance objects.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1606 $
 */
public class InstanceContainerModel
  extends ContainerModel<InstanceContainerManager, InstanceContainer> {

  /** for serialization. */
  private static final long serialVersionUID = -6259301933663814155L;

  /**
   * Initializes the model.
   *
   * @param manager	the managing object to obtain the data from
   */
  public InstanceContainerModel(ContainerListManager<InstanceContainerManager> manager) {
    super((manager == null) ? null : manager.getContainerManager());
  }

  /**
   * Initializes the model.
   *
   * @param manager	the manager to obtain the data from
   */
  public InstanceContainerModel(InstanceContainerManager manager) {
    super(manager);
  }

  /**
   * Initializes the members.
   */
  protected void initialize() {
    super.initialize();

    m_Generator           = new InstanceContainerDisplayIDGenerator();
    m_ColumnNameGenerator = new InstanceContainerTableColumnNameGenerator();
  }
}