/**
 * ArrayConsumerTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.core.option;

/**
 * Tests the ArrayConsumer class.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2819 $
 */
public class ArrayConsumerTest
  extends AbstractOptionConsumerTestCase<String[]> {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public ArrayConsumerTest(String name) {
    super(name);
  }

  /**
   * Tests generating an  option handler from a string, which includes a Weka class.
   */
  public void testFromStringWeka() {
    adams.flow.transformer.InstantiatableTransformer handler = new adams.flow.transformer.InstantiatableTransformer();
    adams.flow.transformer.WekaFilter wekafilter = new adams.flow.transformer.WekaFilter();
    handler.setActor(wekafilter);
    weka.filters.unsupervised.attribute.Remove remove = new weka.filters.unsupervised.attribute.Remove();
    wekafilter.setFilter(remove);
    remove.setAttributeIndices("1-10");

    performFromStringTest(
	ArrayConsumer.class,
	"adams.flow.transformer.InstantiatableTransformer -actor \"adams.flow.transformer.WekaFilter -filter \\\"weka.filters.unsupervised.attribute.Remove -R 1-10\\\"\"",
	handler);
  }
}
