/**
 * NestedConsumerTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.core.option;

import java.util.Vector;

/**
 * Tests the NestedConsumer class.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2819 $
 */
public class NestedConsumerTest
  extends AbstractOptionConsumerTestCase<Vector> {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public NestedConsumerTest(String name) {
    super(name);
  }

  /**
   * Tests generating an  option handler from a string, which includes a Weka class.
   */
  public void testFromStringWeka() {
    adams.flow.transformer.InstantiatableTransformer handler = new adams.flow.transformer.InstantiatableTransformer();
    adams.flow.transformer.WekaFilter wekafilter = new adams.flow.transformer.WekaFilter();
    handler.setActor(wekafilter);
    weka.filters.unsupervised.attribute.Remove remove = new weka.filters.unsupervised.attribute.Remove();
    wekafilter.setFilter(remove);
    remove.setAttributeIndices("1-10");

    performFromStringTest(
	NestedConsumer.class,
	  "adams.flow.transformer.InstantiatableTransformer\n"
	+ "\t-actor\n"
	+ "\t\tadams.flow.transformer.WekaFilter\n"
	+ "\t\t\t-filter\n"
	+ "\t\t\t\tweka.filters.unsupervised.attribute.Remove\n"
	+ "\t\t\t\t\t-R\n"
	+ "\t\t\t\t\t1-10\n",
	handler);
  }
}
