/**
 * RoundErrorScalerTest.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */
package adams.data.weka.predictions;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.env.Environment;

/**
 * Test class for the RoundErrorScaler scaler. Run from the command line with: <p/>
 * java adams.data.weka.predictions.RoundErrorScalerTest
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2208 $
 */
public class RoundErrorScalerTest
  extends AbstractErrorScalerTestCase {

  /**
   * Constructs the test case. Called by subclasses.
   *
   * @param name 	the name of the test
   */
  public RoundErrorScalerTest(String name) {
    super(name);
  }

  /**
   * Returns the filenames (without path) of the input data files to use
   * in the regression test.
   *
   * @return		the filenames
   */
  protected String[] getRegressionInputFiles() {
    return new String[]{
	"double_large.txt",
	"double_large.txt",
	"double_mixed.txt",
	"double_small.txt",
	"integer.txt"
    };
  }

  /**
   * Returns whether the input files contain doubles or integers.
   *
   * @return		true if input file contains integers
   */
  protected boolean[] getRegressionInputFileContainDoubles() {
    return new boolean[]{
	true,
	true,
	true,
	true,
	false
    };
  }

  /**
   * Returns the setups to use in the regression test.
   *
   * @return		the setups
   */
  protected AbstractErrorScaler[] getRegressionSetups() {
    RoundErrorScaler[]	result;

    result = new RoundErrorScaler[5];

    result[0] = new RoundErrorScaler();
    result[1] = new RoundErrorScaler();
    result[2] = new RoundErrorScaler();
    result[3] = new RoundErrorScaler();
    result[4] = new RoundErrorScaler();

    return result;
  }

  /**
   * Returns the test suite.
   *
   * @return		the suite
   */
  public static Test suite() {
    return new TestSuite(RoundErrorScalerTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
