/*
 * WekaInstanceEvaluatorTest.java
 * Copyright (C) 2010-2011 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.transformer;

import junit.framework.Test;
import junit.framework.TestSuite;
import weka.classifiers.functions.GaussianProcesses;
import weka.classifiers.functions.supportVector.RBFKernel;
import adams.data.weka.evaluator.IntervalEstimatorBased;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorReference;
import adams.flow.standalone.GlobalActors;
import adams.flow.source.SequenceSource;
import adams.flow.source.SingleFileSupplier;
import adams.test.TmpFile;

/**
 * Tests the WekaInstanceEvaluator actor.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2909 $
 */
public class WekaInstanceEvaluatorTest
  extends AbstractFlowTest {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public WekaInstanceEvaluatorTest(String name) {
    super(name);
  }

  /**
   * Called by JUnit before each test method.
   *
   * @throws Exception if an error occurs reading the example instances.
   */
  protected void setUp() throws Exception {
    super.setUp();

    m_TestHelper.copyResourceToTmp("bolts.arff");
    m_TestHelper.deleteFileFromTmp("dumpfile.arff");
  }

  /**
   * Called by JUnit after each test method. Removes some tmp files again.
   *
   * @throws Exception	if tear-down fails
   */
  protected void tearDown() throws Exception {
    m_TestHelper.deleteFileFromTmp("bolts.arff");
    m_TestHelper.deleteFileFromTmp("dumpfile.arff");

    super.tearDown();
  }

  /**
   * Used to create an instance of a specific actor.
   *
   * @return a suitably configured <code>AbstractActor</code> value
   */
  public AbstractActor getActor() {
    SingleFileSupplier sfsTrain = new SingleFileSupplier();
    sfsTrain.setFile(new TmpFile("bolts.arff"));

    WekaFileReader frTrain = new WekaFileReader();

    WekaClassSelector csTrain = new WekaClassSelector();

    SequenceSource seqs = new SequenceSource();
    seqs.setName("train");
    seqs.setActors(new AbstractActor[]{
	sfsTrain,
	frTrain,
	csTrain
    });

    GlobalActors ga = new GlobalActors();
    ga.setActors(new AbstractActor[]{
	seqs
    });

    SingleFileSupplier sfs = new SingleFileSupplier();
    sfs.setFile(new TmpFile("bolts.arff"));

    WekaFileReader fr = new WekaFileReader();
    fr.setIncremental(true);

    WekaClassSelector cs = new WekaClassSelector();

    GaussianProcesses gp = new GaussianProcesses();
    gp.setKernel(new RBFKernel());
    gp.setNoise(0.01);
    IntervalEstimatorBased ieb = new IntervalEstimatorBased();
    ieb.setClassifier(gp);
    WekaInstanceEvaluator eval = new WekaInstanceEvaluator();
    eval.setEvaluator(ieb);
    eval.setInstancesActor(new GlobalActorReference("train"));

    WekaInstanceDumper id = new WekaInstanceDumper();
    id.setOutputPrefix(new TmpFile("dumpfile"));

    Flow flow = new Flow();
    flow.setActors(new AbstractActor[]{ga, sfs, fr, cs, eval, id});

    return flow;
  }

  /**
   * Performs a regression test, comparing against previously generated output.
   */
  public void testRegression() {
    performRegressionTest(
	new TmpFile("dumpfile.arff"));
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(WekaInstanceEvaluatorTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
