/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Branch;
import adams.flow.control.Flow;
import adams.flow.control.Sequence;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorReference;
import adams.flow.sink.DumpFile;
import adams.flow.sink.GlobalSink;
import adams.flow.source.SingleFileSupplier;
import adams.flow.standalone.GlobalActors;
import adams.flow.transformer.Copy;
import adams.flow.transformer.WekaFileReader;
import adams.flow.transformer.WekaRelationName;
import adams.flow.transformer.WekaRenameRelation;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class WekaRenameRelationTest
extends AbstractFlowTest {
    public WekaRenameRelationTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public AbstractActor getActor() {
        DumpFile df = new DumpFile();
        df.setName("sink");
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        GlobalActors ga = new GlobalActors();
        ga.setActors(new AbstractActor[]{df});
        SingleFileSupplier sfs = new SingleFileSupplier();
        sfs.setFile((PlaceholderFile)new TmpFile("vote.arff"));
        WekaFileReader fr = new WekaFileReader();
        Copy copy = new Copy();
        WekaRenameRelation ren1 = new WekaRenameRelation();
        ren1.setReplace("branch1");
        WekaRelationName rel1 = new WekaRelationName();
        GlobalSink sink1 = new GlobalSink();
        sink1.setGlobalName(new GlobalActorReference("sink"));
        Sequence seq1 = new Sequence();
        seq1.setActors(new AbstractActor[]{ren1, rel1, sink1});
        WekaRenameRelation ren2 = new WekaRenameRelation();
        ren2.setReplace("branch2");
        WekaRelationName rel2 = new WekaRelationName();
        GlobalSink sink2 = new GlobalSink();
        sink2.setGlobalName(new GlobalActorReference("sink"));
        Sequence seq2 = new Sequence();
        seq2.setActors(new AbstractActor[]{ren2, rel2, sink2});
        Branch br = new Branch();
        br.setNumThreads(0);
        br.setBranches(new AbstractActor[]{seq1, seq2});
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{ga, sfs, fr, copy, br});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.txt"));
    }

    public static Test suite() {
        return new TestSuite(WekaRenameRelationTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaRenameRelationTest.runTest((Test)WekaRenameRelationTest.suite());
    }
}

