/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.ArffLoader;
import weka.core.converters.CSVLoader;

public class WekaInstanceDumper
extends AbstractTransformer {
    private static final long serialVersionUID = 5071747277597147724L;
    public static final String BACKUP_HEADER = "header";
    public static final String BACKUP_COUNTER = "counter";
    protected Instances m_Header;
    protected int m_Counter;
    protected boolean m_CheckHeader;
    protected PlaceholderFile m_OutputPrefix;
    protected OutputFormat m_OutputFormat;
    protected boolean m_UseRelationNameAsFilename;
    protected boolean m_KeepExisting;

    public String globalInfo() {
        return "Dumps weka.core.Instance objects into an ARFF file. If the headers change and the header-check is enabled, then a new file will be used.\nThe actor can also turn double arrays into weka.core.Instance objects (all attributes are assumed to be numeric).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("check", "checkHeader", (Object)false);
        this.m_OptionManager.add("prefix", "outputPrefix", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("format", "outputFormat", (Object)OutputFormat.ARFF);
        this.m_OptionManager.add("use-relation", "useRelationNameAsFilename", (Object)false);
        this.m_OptionManager.add("keep-existing", "keepExisting", (Object)false);
    }

    public String getQuickInfo() {
        String result = this.m_OutputFormat.toString() + ": ";
        String variable = this.getOptionManager().getVariableForProperty("outputPrefix");
        result = variable != null ? (this.m_UseRelationNameAsFilename ? result + variable + " using <relation>" : result + variable) : (this.m_UseRelationNameAsFilename ? result + new PlaceholderFile(this.m_OutputPrefix.getParent()).toString() + File.separator + "<relation>" : result + this.m_OutputPrefix.toString());
        return result;
    }

    public void setCheckHeader(boolean value) {
        this.m_CheckHeader = value;
        this.reset();
    }

    public boolean getCheckHeader() {
        return this.m_CheckHeader;
    }

    public String checkHeaderTipText() {
        return "Whether to check the headers - if the headers change, the Instance object gets dumped into a new file.";
    }

    public void setOutputPrefix(PlaceholderFile value) {
        String prefix = value.toString();
        if (prefix.toLowerCase().endsWith(".arff") || prefix.toLowerCase().endsWith(".csv")) {
            value = new PlaceholderFile(prefix.substring(0, prefix.lastIndexOf(46)));
        }
        this.m_OutputPrefix = value;
        this.reset();
    }

    public PlaceholderFile getOutputPrefix() {
        return this.m_OutputPrefix;
    }

    public String outputPrefixTipText() {
        return "The path and partial filename of the output file; automatically removes 'arff' and 'csv' extensions, as they get added automatically.";
    }

    public void setOutputFormat(OutputFormat value) {
        this.m_OutputFormat = value;
        this.reset();
    }

    public OutputFormat getOutputFormat() {
        return this.m_OutputFormat;
    }

    public String outputFormatTipText() {
        return "The format to output the data in.";
    }

    public void setUseRelationNameAsFilename(boolean value) {
        this.m_UseRelationNameAsFilename = value;
        this.reset();
    }

    public boolean getUseRelationNameAsFilename() {
        return this.m_UseRelationNameAsFilename;
    }

    public String useRelationNameAsFilenameTipText() {
        return "If set to true, then the relation name replaces the name of the output file; eg if the output file is '/some/where/file.arff' and the relation is 'anneal' then the resulting file name will be '/some/where/anneal.arff'.";
    }

    public void setKeepExisting(boolean value) {
        this.m_KeepExisting = value;
        this.reset();
    }

    public boolean getKeepExisting() {
        return this.m_KeepExisting;
    }

    public String keepExistingTipText() {
        return "If enabled, any output file that exists when the actor is executed for the first time won't get replaced with the current header; useful when outputting data in multiple locations in the flow, but one needs to be cautious as to not stored mixed content (eg varying number of attributes, etc).";
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_Header != null) {
            result.put(BACKUP_HEADER, this.m_Header);
            result.put(BACKUP_COUNTER, this.m_Counter);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_HEADER)) {
            this.m_Header = (Instances)state.get(BACKUP_HEADER);
            state.remove(BACKUP_HEADER);
        }
        if (state.containsKey(BACKUP_COUNTER)) {
            this.m_Counter = (Integer)state.get(BACKUP_COUNTER);
            state.remove(BACKUP_COUNTER);
        }
        super.restoreState(state);
    }

    protected void reset() {
        super.reset();
        this.m_Counter = 0;
        this.m_Header = null;
    }

    public Class[] accepts() {
        return new Class[]{Instance.class, double[].class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    public String setUp() {
        File file;
        String result = super.setUp();
        if (result == null && !(file = new File(this.m_OutputPrefix.getAbsolutePath())).getParentFile().exists()) {
            result = "Parent directory does not exist: " + file.getParentFile();
        }
        return result;
    }

    protected File createFilename(Instances header) {
        String result;
        if (this.m_UseRelationNameAsFilename) {
            File file = new File(this.m_OutputPrefix.getAbsolutePath());
            result = file.getParent() + File.separator + FileUtils.createFilename((String)header.relationName(), (String)"_");
        } else {
            result = this.m_OutputPrefix.getAbsolutePath();
        }
        if (this.m_Counter > 0) {
            result = result + "-" + this.m_Counter;
        }
        switch (this.m_OutputFormat) {
            case ARFF: {
                result = result + ArffLoader.FILE_EXTENSION;
                break;
            }
            case CSV: {
                result = result + CSVLoader.FILE_EXTENSION;
                break;
            }
            case TAB: {
                result = result + CSVLoader.FILE_EXTENSION;
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled output format: " + (Object)((Object)this.m_OutputFormat));
            }
        }
        return new File(result);
    }

    protected String createHeader(Instances header) {
        StringBuilder result = new StringBuilder();
        switch (this.m_OutputFormat) {
            case ARFF: {
                result.append(new Instances(header, 0).toString());
                break;
            }
            case CSV: {
                for (int i = 0; i < header.numAttributes(); ++i) {
                    if (i > 0) {
                        result.append(",");
                    }
                    result.append(Utils.quote((String)header.attribute(i).name()));
                }
                break;
            }
            case TAB: {
                for (int i = 0; i < header.numAttributes(); ++i) {
                    if (i > 0) {
                        result.append("\t");
                    }
                    result.append(Utils.quote((String)header.attribute(i).name()));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled output format: " + (Object)((Object)this.m_OutputFormat));
            }
        }
        return result.toString();
    }

    protected String createRow(Instance row) {
        StringBuilder result = new StringBuilder();
        switch (this.m_OutputFormat) {
            case ARFF: {
                result.append(row.toString());
                break;
            }
            case CSV: {
                for (int i = 0; i < row.numAttributes(); ++i) {
                    if (i > 0) {
                        result.append(",");
                    }
                    result.append(row.toString(i));
                }
                break;
            }
            case TAB: {
                for (int i = 0; i < row.numAttributes(); ++i) {
                    if (i > 0) {
                        result.append("\t");
                    }
                    result.append(row.toString(i));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled output format: " + (Object)((Object)this.m_OutputFormat));
            }
        }
        return result.toString();
    }

    protected String doExecute() {
        Instances newHeader;
        Instance inst;
        String result = null;
        if (this.m_InputToken.getPayload() instanceof Instance) {
            inst = (Instance)this.m_InputToken.getPayload();
            newHeader = inst.dataset();
        } else {
            double[] values = (double[])this.m_InputToken.getPayload();
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            for (int i = 0; i < values.length; ++i) {
                atts.add(new Attribute("att_" + (i + 1)));
            }
            newHeader = new Instances(this.getName(), atts, 0);
            inst = new DenseInstance(1.0, values);
            inst.setDataset(newHeader);
        }
        boolean append = true;
        if (this.m_Header == null) {
            this.m_Header = new Instances(newHeader, 0);
            if (!this.m_KeepExisting) {
                append = false;
            }
        } else if (this.m_CheckHeader && !this.m_Header.equalHeaders(newHeader)) {
            ++this.m_Counter;
            this.m_Header = new Instances(newHeader, 0);
            append = false;
        }
        File outputFile = this.createFilename(inst.dataset());
        boolean ok = true;
        if (!outputFile.exists() || !append) {
            ok = FileUtils.writeToFile((String)outputFile.getAbsolutePath(), (Object)this.createHeader(inst.dataset()), (boolean)false);
        }
        if (ok) {
            ok = FileUtils.writeToFile((String)outputFile.getAbsolutePath(), (Object)this.createRow(inst), (boolean)true);
        }
        if (!ok) {
            result = "Failed to write to file: " + outputFile;
        }
        if (ok) {
            this.m_OutputToken = new Token((Object)outputFile.getAbsolutePath());
        }
        return result;
    }

    public void wrapUp() {
        super.wrapUp();
        this.m_Header = null;
    }

    public static enum OutputFormat {
        ARFF,
        CSV,
        TAB;

    }
}

