/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import weka.classifiers.functions.LinearRegression;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.NormalizableDistance;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.neighboursearch.PerformanceStats;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Normalize;

public class WeightedEuclideanDistance
extends NormalizableDistance
implements Cloneable,
TechnicalInformationHandler {
    private static final long serialVersionUID = -8518647249857218705L;
    protected double[] m_Coefficients = null;
    protected LinearRegression m_LR = new LinearRegression();
    protected Normalize m_norm = null;

    public WeightedEuclideanDistance() {
    }

    public WeightedEuclideanDistance(Instances data) {
        super(data);
    }

    protected void initialize() {
        super.initialize();
        this.m_LR.setAttributeSelectionMethod(new SelectedTag(1, LinearRegression.TAGS_SELECTION));
        this.m_LR.setEliminateColinearAttributes(false);
        this.m_norm = new Normalize();
        try {
            this.m_norm.setInputFormat(this.m_Data);
            Instances in = Filter.useFilter((Instances)this.m_Data, (Filter)this.m_norm);
            this.m_LR.buildClassifier(in);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_Coefficients = this.m_LR.coefficients();
        for (int i = 0; i < this.m_Coefficients.length; ++i) {
        }
    }

    public String globalInfo() {
        return "Implementing Euclidean distance (or similarity) function.\n\nOne object defines not one distance but the data model in which the distances between objects of that data model can be computed.\n\nAttention: For efficiency reasons the use of consistency checks (like are the data models of the two instances exactly the same), is low.\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Wikipedia");
        result.setValue(TechnicalInformation.Field.TITLE, "Euclidean distance");
        result.setValue(TechnicalInformation.Field.URL, "http://en.wikipedia.org/wiki/Euclidean_distance");
        return result;
    }

    public double distance(Instance first, Instance second) {
        return Math.sqrt(this.distance(this.transform(first), this.transform(second), Double.POSITIVE_INFINITY));
    }

    public double distance(Instance first, Instance second, PerformanceStats stats) {
        return Math.sqrt(this.distance(this.transform(first), this.transform(second), Double.POSITIVE_INFINITY, stats));
    }

    protected double updateDistance(double currDist, double diff) {
        double result = currDist;
        return result += diff * diff;
    }

    public double distance(Instance first, Instance second, double cutOffValue, PerformanceStats stats) {
        return super.distance(this.transform(first), this.transform(second), cutOffValue, stats);
    }

    protected double difference(int index, double val1, double val2) {
        if (index == this.m_Data.classIndex()) {
            return 0.0;
        }
        return (val1 - val2) * this.m_Coefficients[index];
    }

    public void postProcessDistances(double[] distances) {
        for (int i = 0; i < distances.length; ++i) {
            distances[i] = Math.sqrt(distances[i]);
        }
    }

    public double sqDifference(int index, double val1, double val2) {
        double val = this.difference(index, val1, val2);
        return val * val;
    }

    public double getMiddle(double[] ranges) {
        double middle = ranges[0] + ranges[2] * 0.5;
        return middle;
    }

    protected Instance transform(Instance i) {
        try {
            this.m_norm.input(i);
            this.m_norm.batchFinished();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.m_norm.output();
    }

    public boolean valueIsSmallerEqual(Instance instance, int dim, double value) {
        return instance.value(dim) <= value;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 4584 $");
    }
}

