/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize.plugins;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.Utils;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.VisualizePanel;
import weka.gui.visualize.plugins.ErrorVisualizePlugin;

public class FixedClassifierErrors
implements ErrorVisualizePlugin {
    public static final int PLOT_SIZE = 4;

    public JMenuItem getVisualizeMenuItem(Instances predInst) {
        final Instances predInstF = predInst;
        JMenuItem result = new JMenuItem("Classifier errors (fixed)");
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualizePanel vp = new VisualizePanel();
                vp.setName("Absolute classifier errors for " + predInstF.relationName());
                PlotData2D tempd = new PlotData2D(predInstF);
                FastVector plotSize = new FastVector();
                FastVector plotShape = new FastVector();
                for (int i = 0; i < predInstF.numInstances(); ++i) {
                    double actual = predInstF.instance(i).value(predInstF.classIndex());
                    double predicted = predInstF.instance(i).value(predInstF.classIndex() - 1);
                    if (predInstF.classAttribute().isNominal()) {
                        if (Utils.isMissingValue((double)actual) || Utils.isMissingValue((double)predicted)) {
                            plotShape.addElement((Object)new Integer(2000));
                        } else if (actual != predicted) {
                            plotShape.addElement((Object)new Integer(1000));
                        } else {
                            plotShape.addElement((Object)new Integer(-1));
                        }
                        plotSize.addElement((Object)new Integer(4));
                        continue;
                    }
                    if (Utils.isMissingValue((double)actual) || Utils.isMissingValue((double)predicted)) {
                        plotShape.addElement((Object)new Integer(2000));
                    } else {
                        plotShape.addElement((Object)new Integer(-1));
                    }
                    plotSize.addElement((Object)4);
                }
                try {
                    tempd.setShapeSize(plotSize);
                    tempd.setShapeType(plotShape);
                    tempd.setPlotName("Absolute classifier errors for " + predInstF.relationName());
                    tempd.addInstanceNumberAttribute();
                    vp.addPlot(tempd);
                    vp.setColourIndex(predInstF.classIndex() + 1);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return;
                }
                try {
                    vp.setXIndex(vp.getInstances().classIndex());
                    vp.setYIndex(vp.getInstances().classIndex() - 1);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                final JFrame jf = new JFrame("Classifier errors for " + predInstF.relationName());
                jf.setSize(600, 400);
                jf.getContentPane().setLayout(new BorderLayout());
                jf.getContentPane().add((Component)vp, "Center");
                jf.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        jf.dispose();
                    }
                });
                jf.setVisible(true);
            }
        });
        return result;
    }

    public String getMinVersion() {
        return "3.5.9";
    }

    public String getMaxVersion() {
        return "3.7.0";
    }

    public String getDesignVersion() {
        return "3.6.0";
    }
}

