/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ArffLoader;
import weka.core.converters.ConverterUtils;
import weka.core.converters.Loader;
import weka.core.converters.URLSourcedLoader;

public class WekaFileReader
extends AbstractTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = 9097157984356638281L;
    public static final String BACKUP_STRUCTURE = "structure";
    public static final String BACKUP_SOURCE = "source";
    protected boolean m_UseCustomLoader;
    protected AbstractFileLoader m_CustomLoader;
    protected boolean m_Incremental;
    protected Instances m_Structure;
    protected ConverterUtils.DataSource m_Source;

    public String globalInfo() {
        return "Reads any file format that Weka's converters can handle and returns the full dataset or single weka.core.Instance objects. This actor takes the file or URL to read as input. In case of URLs, the associated loader must implement " + URLSourcedLoader.class.getName() + ".";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("use-custom", "useCustomLoader", (Object)false);
        this.m_OptionManager.add("loader", "customLoader", (Object)new ArffLoader());
        this.m_OptionManager.add("incremental", "incremental", (Object)false);
    }

    public String getQuickInfo() {
        String variable;
        String result = null;
        result = this.m_UseCustomLoader ? ((variable = this.getOptionManager().getVariableForProperty("loader")) != null ? variable : this.getCustomLoader().getClass().getName()) : "automatic";
        if (this.m_Incremental) {
            result = result + " (incremental)";
        }
        return result;
    }

    public Class[] accepts() {
        Vector<Class<URL>> result = new Vector<Class<URL>>();
        result.add(String.class);
        result.add(File.class);
        if (this.getUseCustomLoader()) {
            if (this.getCustomLoader() instanceof URLSourcedLoader) {
                result.add(URL.class);
            }
        } else {
            result.add(URL.class);
        }
        return result.toArray(new Class[result.size()]);
    }

    public Class[] generates() {
        if (this.m_Incremental) {
            return new Class[]{Instance.class};
        }
        return new Class[]{Instances.class};
    }

    public void setUseCustomLoader(boolean value) {
        this.m_UseCustomLoader = value;
        this.reset();
    }

    public boolean getUseCustomLoader() {
        return this.m_UseCustomLoader;
    }

    public String useCustomLoaderTipText() {
        return "If set to true, then the custom loader will be used for loading the data.";
    }

    public void setCustomLoader(AbstractFileLoader value) {
        this.m_CustomLoader = value;
        this.reset();
    }

    public AbstractFileLoader getCustomLoader() {
        return this.m_CustomLoader;
    }

    public String customLoaderTipText() {
        return "The custom loader to use if enabled.";
    }

    public void setIncremental(boolean value) {
        this.m_Incremental = value;
        this.reset();
    }

    public boolean getIncremental() {
        return this.m_Incremental;
    }

    public String incrementalTipText() {
        return "If set to true, then single Instance objects are output, otherwise just one Instances object.";
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_STRUCTURE);
        this.pruneBackup(BACKUP_SOURCE);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_Structure != null) {
            result.put(BACKUP_STRUCTURE, this.m_Structure);
        }
        if (this.m_Source != null) {
            result.put(BACKUP_SOURCE, this.m_Source);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_STRUCTURE)) {
            this.m_Structure = (Instances)state.get(BACKUP_STRUCTURE);
            state.remove(BACKUP_STRUCTURE);
        }
        if (state.containsKey(BACKUP_SOURCE)) {
            this.m_Source = (ConverterUtils.DataSource)state.get(BACKUP_SOURCE);
            state.remove(BACKUP_SOURCE);
        }
        super.restoreState(state);
    }

    protected void reset() {
        super.reset();
        this.m_Structure = null;
        this.m_Source = null;
    }

    protected String doExecute() {
        String result = null;
        try {
            Object obj = this.m_InputToken.getPayload();
            File file = null;
            URL url = null;
            if (obj instanceof File) {
                file = (File)obj;
            } else if (obj instanceof URL) {
                url = (URL)obj;
            } else {
                file = new PlaceholderFile((String)obj);
            }
            if (this.m_UseCustomLoader) {
                AbstractFileLoader loader = this.m_CustomLoader;
                if (url != null) {
                    ((URLSourcedLoader)loader).setURL(url.toString());
                } else {
                    loader.setFile(file);
                }
                this.m_Source = new ConverterUtils.DataSource((Loader)loader);
            } else {
                this.m_Source = url != null ? new ConverterUtils.DataSource(url.toString()) : new ConverterUtils.DataSource(file.getAbsolutePath());
            }
            this.m_Structure = this.m_Source.getStructure();
        }
        catch (Exception e) {
            result = e.toString();
            this.getSystemErr().printStackTrace((Throwable)e);
        }
        return result;
    }

    public Token output() {
        Token result;
        if (this.m_Incremental) {
            result = new Token((Object)this.m_Source.nextElement(this.m_Structure));
            if (!this.m_Source.hasMoreElements(this.m_Structure)) {
                this.m_Structure = null;
                this.m_Source = null;
            }
        } else {
            try {
                result = new Token((Object)this.m_Source.getDataSet());
            }
            catch (Exception e) {
                result = null;
                this.getSystemErr().printStackTrace((Throwable)e);
            }
            this.m_Structure = null;
            this.m_Source = null;
        }
        this.updateProvenance((ProvenanceContainer)result);
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            cont.addProvenance(new ProvenanceInformation(ActorType.DATAGENERATOR, (AbstractActor)this, ((Token)cont).getPayload().getClass()));
        }
    }

    public boolean hasPendingOutput() {
        return this.m_Structure != null && this.m_Source.hasMoreElements(this.m_Structure);
    }

    public void wrapUp() {
        this.m_Structure = null;
        this.m_Source = null;
        super.wrapUp();
    }
}

