/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractTransformer;
import java.util.Hashtable;
import java.util.Iterator;
import weka.core.BinarySparseInstance;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SparseInstance;

public class WekaInstanceBuffer
extends AbstractTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = 6774529845778672623L;
    public static final String BACKUP_BUFFER = "buffer";
    public static final String BACKUP_ITERATOR = "iterator";
    protected Instances m_Buffer;
    protected Iterator<Instance> m_Iterator;
    protected Operation m_Operation;
    protected boolean m_CheckHeader;

    public String globalInfo() {
        return "Can act in two different ways:\n1. Instance -> Instances (row -> dataset)\nBuffers weka.core.Instance objects and outputs a weka.core.Instances object with each arriving weka.core.Instance object.\n2. Instances -> Instance (dataset -> row)\nOutputs all the weka.core.Instance objects that the incoming weka.core.Instances object contains.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("operation", "operation", (Object)Operation.INSTANCE_TO_INSTANCES);
        this.m_OptionManager.add("check", "checkHeader", (Object)false);
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("operation");
        String result = variable != null ? variable : this.m_Operation.toString();
        if (this.m_CheckHeader) {
            result = result + " [checking header]";
        }
        return result;
    }

    public void setOperation(Operation value) {
        this.m_Operation = value;
        this.reset();
    }

    public Operation getOperation() {
        return this.m_Operation;
    }

    public String operationTipText() {
        return "The way the buffer operates, 'dataset -> row' or 'row -> dataset'.";
    }

    public void setCheckHeader(boolean value) {
        this.m_CheckHeader = value;
        this.reset();
    }

    public boolean getCheckHeader() {
        return this.m_CheckHeader;
    }

    public String checkHeaderTipText() {
        return "Whether to check the headers - if the headers change, the Instance object gets dumped into a new file (in case of " + (Object)((Object)Operation.INSTANCE_TO_INSTANCES) + ").";
    }

    public Class[] accepts() {
        if (this.m_Operation == Operation.INSTANCE_TO_INSTANCES) {
            return new Class[]{Instance.class, Instance[].class};
        }
        if (this.m_Operation == Operation.INSTANCES_TO_INSTANCE) {
            return new Class[]{Instances.class};
        }
        throw new IllegalStateException("Unhandled operation: " + (Object)((Object)this.m_Operation));
    }

    public Class[] generates() {
        if (this.m_Operation == Operation.INSTANCE_TO_INSTANCES) {
            return new Class[]{Instances.class};
        }
        if (this.m_Operation == Operation.INSTANCES_TO_INSTANCE) {
            return new Class[]{Instance.class};
        }
        throw new IllegalStateException("Unhandled operation: " + (Object)((Object)this.m_Operation));
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_BUFFER);
        this.pruneBackup(BACKUP_ITERATOR);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_Buffer != null) {
            result.put(BACKUP_BUFFER, this.m_Buffer);
        }
        if (this.m_Iterator != null) {
            result.put(BACKUP_ITERATOR, this.m_Iterator);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_BUFFER)) {
            this.m_Buffer = (Instances)state.get(BACKUP_BUFFER);
            state.remove(BACKUP_BUFFER);
        }
        if (state.containsKey(BACKUP_ITERATOR)) {
            this.m_Iterator = (Iterator)state.get(BACKUP_ITERATOR);
            state.remove(BACKUP_ITERATOR);
        }
        super.restoreState(state);
    }

    protected void reset() {
        super.reset();
        this.m_Buffer = null;
        this.m_Iterator = null;
    }

    protected String doExecute() {
        String result = null;
        if (this.m_Operation == Operation.INSTANCE_TO_INSTANCES) {
            Instance[] insts = this.m_InputToken.getPayload() instanceof Instance ? new Instance[]{(Instance)this.m_InputToken.getPayload()} : (Instance[])this.m_InputToken.getPayload();
            for (int n = 0; n < insts.length; ++n) {
                Instance inst = insts[n];
                if (this.m_Buffer != null && this.m_CheckHeader && !this.m_Buffer.equalHeaders(inst.dataset())) {
                    this.debug("Header changed, resetting buffer");
                    this.m_Buffer = null;
                }
                if (this.m_Buffer == null) {
                    this.m_Buffer = new Instances(inst.dataset(), 0);
                }
                double[] values = inst.toDoubleArray();
                boolean updated = false;
                for (int i = 0; i < values.length; ++i) {
                    if (inst.isMissing(i)) continue;
                    if (inst.attribute(i).isString()) {
                        values[i] = this.m_Buffer.attribute(i).addStringValue(inst.stringValue(i));
                        updated = true;
                        continue;
                    }
                    if (!inst.attribute(i).isRelationValued()) continue;
                    values[i] = this.m_Buffer.attribute(i).addRelation(inst.relationalValue(i));
                    updated = true;
                }
                if (updated) {
                    if (inst instanceof SparseInstance) {
                        inst = new SparseInstance(inst.weight(), values);
                    } else if (inst instanceof BinarySparseInstance) {
                        inst = new BinarySparseInstance(inst.weight(), values);
                    } else {
                        if (!(inst instanceof DenseInstance)) {
                            this.getSystemErr().println("Unhandled instance class (" + inst.getClass().getName() + "), " + "defaulting to " + DenseInstance.class.getName());
                        }
                        inst = new DenseInstance(inst.weight(), values);
                    }
                } else {
                    inst = (Instance)inst.copy();
                }
                this.m_Buffer.add(inst);
            }
            this.m_OutputToken = new Token((Object)this.m_Buffer);
        } else if (this.m_Operation == Operation.INSTANCES_TO_INSTANCE) {
            this.m_Buffer = (Instances)this.m_InputToken.getPayload();
            this.m_Iterator = this.m_Buffer.iterator();
        } else {
            throw new IllegalStateException("Unhandled operation: " + (Object)((Object)this.m_Operation));
        }
        return result;
    }

    public boolean hasPendingOutput() {
        if (this.m_Operation == Operation.INSTANCE_TO_INSTANCES) {
            return super.hasPendingOutput();
        }
        if (this.m_Operation == Operation.INSTANCES_TO_INSTANCE) {
            return this.m_Iterator != null && this.m_Iterator.hasNext();
        }
        throw new IllegalStateException("Unhandled operation: " + (Object)((Object)this.m_Operation));
    }

    public Token output() {
        Token result;
        if (this.m_Operation == Operation.INSTANCE_TO_INSTANCES) {
            result = this.m_OutputToken;
            this.m_OutputToken = null;
        } else if (this.m_Operation == Operation.INSTANCES_TO_INSTANCE) {
            result = new Token((Object)this.m_Iterator.next());
        } else {
            throw new IllegalStateException("Unhandled operation: " + (Object)((Object)this.m_Operation));
        }
        this.updateProvenance((ProvenanceContainer)result);
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            cont.setProvenance(this.m_InputToken.getProvenance());
            cont.addProvenance(new ProvenanceInformation(ActorType.PREPROCESSOR, this.m_InputToken.getPayload().getClass(), (AbstractActor)this, ((Token)cont).getPayload().getClass()));
        }
    }

    public void wrapUp() {
        this.m_Iterator = null;
        this.m_Buffer = null;
        super.wrapUp();
    }

    public static enum Operation {
        INSTANCES_TO_INSTANCE,
        INSTANCE_TO_INSTANCES;

    }
}

