/*
 * Decompiled with CFR 0.152.
 */
package adams.data.baseline;

import adams.core.Utils;
import adams.data.baseline.AbstractBaselineCorrection;
import adams.data.container.DataContainer;
import weka.classifiers.functions.LinearRegression;
import weka.core.Instances;
import weka.core.SelectedTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLinearRegressionBased<T extends DataContainer>
extends AbstractBaselineCorrection<T> {
    private static final long serialVersionUID = -6634948158083409766L;
    protected double m_Ridge;
    protected boolean m_GenerateLine;

    public String globalInfo() {
        return "A simple linear regression based baseline correction scheme.\nFits a line through the data using linear regression and then removes this line from the data to correct the baseline.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("ridge", "ridge", (Object)1.0E-8);
        this.m_OptionManager.add("line", "generateLine", (Object)false);
    }

    public void setRidge(double value) {
        this.m_Ridge = value;
        this.reset();
    }

    public double getRidge() {
        return this.m_Ridge;
    }

    public String ridgeTipText() {
        return "The ridge parameter for linear regression.";
    }

    public void setGenerateLine(boolean value) {
        this.m_GenerateLine = value;
        this.reset();
    }

    public boolean getGenerateLine() {
        return this.m_GenerateLine;
    }

    public String generateLineTipText() {
        return "Whether to generate the determined line instead of correcting the data.";
    }

    protected abstract Instances getInstances(T var1);

    protected abstract T correctData(T var1, double[] var2);

    protected abstract T generateLine(T var1, double[] var2);

    protected T processData(T data) {
        Object result;
        Instances inst = this.getInstances(data);
        if (this.isDebugOn()) {
            this.debug("inst:\n" + inst);
        }
        try {
            LinearRegression linear = new LinearRegression();
            linear.setAttributeSelectionMethod(new SelectedTag(1, LinearRegression.TAGS_SELECTION));
            linear.setEliminateColinearAttributes(false);
            linear.buildClassifier(inst);
            double[] coeff = linear.coefficients();
            if (this.isDebugOn()) {
                this.debug("coeff: " + Utils.arrayToString((Object)coeff));
            }
            result = this.getGenerateLine() ? this.generateLine(data, coeff) : this.correctData(data, coeff);
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace((Throwable)e);
            result = (DataContainer)data.getClone();
        }
        return (T)result;
    }
}

